@extends('layouts.app')
@section('title','Card Type')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>Card Type</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                
                <li class="breadcrumb-item active" aria-current="page">Add New Card Type</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width" action="{{route('card-type.store')}}" class="ajaxformfileupload" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @csrf
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Card Type</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                     <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
                     <div class="input-group has-validation"> <span class="input-group-text" id="inputGroupPrepend"><i class="bi-credit-card"></i></span>
                      <input type="text" class="form-control" name="name" id="name" placeholder="Name" required="">
                      @if ($errors->has('name'))
                      <span class="text-danger">{{ $errors->first('name') }}</span>
                      @endif
                    </div>	
                  </div>						
                  <div class="col-md-12">
                    <label for="book_limit" class="form-label">Book  Limit <span class="text-danger"><b>*</b></span></label>
                    <input type="number" class="form-control" name="book_limit" id="book_limit" placeholder="Book Limit" required>
                    @if ($errors->has('book_limit'))
                    <span class="text-danger">{{ $errors->first('book_limit') }}</span>
                    @endif
                  </div>
                  <div class="col-md-12">
                    <label for="library_card_serial" class="form-label">Library Card Serial <span class="text-danger"><b>*</b></span></label>
                    <input type="text" class="form-control" name="library_card_serial" id="library_card_serial" placeholder="Library Card Serial" required>
                  </div>
                  <div class="col-12" align="center">
                    <div class="d-grid gap-2 with-50">
                      <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Save Data</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6 col-sm-12">
            <div class="card">
              <div class="card-body">
                <div class="g-3 row">
                  <h5 class="mb-0">Card Type</h5>
                  <hr class="mb-0">
                  <div class="col-md-12">
                    <label for="card_no_length" class="form-label">Card No Length <span class="text-danger"><b>*</b></span></label>
                    <input type="number" class="form-control" name="card_no_length" id="card_no_length" placeholder="Card No Length" required>
                    @if ($errors->has('card_no_length'))
                    <span class="text-danger">{{ $errors->first('card_no_length') }}</span>
                    @endif
                  </div>	
                  <div class="col-md-12">
                    <label for="serial_start_from" class="form-label">Serial Start From <span class="text-danger"><b>*</b></span></label>
                    <input type="text" class="form-control" name="serial_start_from" id="serial_start_from" placeholder="Serial Start From" required>
                    @if ($errors->has('serial_start_from'))
                    <span class="text-danger">{{ $errors->first('serial_start_from') }}</span>
                    @endif
                  </div>
                  <div class="col-md-12">
                    <label for="prefix_code" class="form-label">Prefix Code <span class="text-danger"><b>*</b></span></label>
                    <input type="text" class="form-control" name="prefix_code" id="prefix_code" placeholder="Prefix code" required>
                    @if ($errors->has('prefix_code'))
                    <span class="text-danger">{{ $errors->first('prefix_code') }}</span>
                    @endif
                  </div>
                  <div class="col-md-12">
                    <label for="suffix_code" class="form-label">Suffix Code <span class="text-danger"><b>*</b></span></label>
                    <input type="text" class="form-control" name="suffix_code" id="suffix_code" placeholder="Suffix Code" required>
                    @if ($errors->has('suffix_code'))
                    <span class="text-danger">{{ $errors->first('suffix_code') }}</span>
                    @endif
                  </div>	
                  
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
<!--end row-->
@endsection