@extends('layouts.app')
@section('title','Membership Plan')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>Membership Plan</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Edit Membership Plan</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('membership-plan.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width" action="{{route('membership-plan.update',$MembershipPlan->id)}}" class="ajaxformfileupload" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @csrf
            @method('PUT')
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Membership Plan</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                     <label for="name" class="form-label">Plan Name <span class="text-danger"><b>*</b></span></label>
                     <input type="text" class="form-control" name="name" placeholder="Plan Name" value="@if(isset($MembershipPlan->name)){{$MembershipPlan->name}}@endif" required>
                     @if ($errors->has('name'))
                     <span class="text-danger">{{ $errors->first('name') }}</span>
                     @endif

                   </div>
                   <div class="col-md-12">
                    <label for="book_limit" class="form-label">Book  Limit<span class="text-danger"><b>*</b></span></label>
                    <input type="text" class="form-control" name="book_limit" placeholder="Book Limit" value="@if(isset($MembershipPlan->book_limit)){{$MembershipPlan->book_limit}}@endif" required>
                    @if ($errors->has('book_limit'))
                    <span class="text-danger">{{ $errors->first('book_limit') }}</span>
                    @endif
                  </div>
                  <div class="col-md-12">
                    <label for="book_validity" class="form-label">Book Validity in days<span class="text-danger"><b>*</b></span></label>
                    <input type="text" class="form-control" name="book_validity" id="book_validity" value="@if(isset($MembershipPlan->book_validity)){{$MembershipPlan->book_validity}}@endif" placeholder="Book Validity in days"  required>
                  </div>
                  <div class="col-12" align="center">
                    <div class="d-grid gap-2">
                      <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Update Membership</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6 col-sm-12">
            <div class="card">
              <div class="card-body">
                <div class="g-3 row">
                  <h5 class="mb-0">Membership Plan</h5>
                  <hr class="mb-0">
                  <div class="col-md-12">
                   <label for="name" class="form-label">Fees Plan </label>
                   <select class="form-control" name="fees_plan">
                    <option value=" ">--Select--</option>
                    <option value="Per Month" @if(isset($MembershipPlan->fees_plan) && $MembershipPlan->fees_plan=='Per Month'){{'selected'}}@endif>Per Month</option>
                    <option value="Per Quarter" @if(isset($MembershipPlan->fees_plan) && $MembershipPlan->fees_plan=='Per Quarter'){{'selected'}}@endif>Per Quarter</option>
                    <option value="Per Year" @if(isset($MembershipPlan->fees_plan) && $MembershipPlan->fees_plan=='Per Year'){{'selected'}}@endif>Per Year</option>
                  </select>
                  @if ($errors->has('fees_plan'))
                  <span class="text-danger">{{ $errors->first('fees_plan') }}</span>
                  @endif

                </div>
                <div class="col-md-12">
                  <label for="fees" class="form-label">Fees </label>
                  <input type="text" class="form-control" name="fees" placeholder="Fees" value="@if(isset($MembershipPlan->fees)){{$MembershipPlan->fees}}@endif">
                  @if ($errors->has('fees'))
                  <span class="text-danger">{{ $errors->first('fees') }}</span>
                  @endif
                </div>
                <div class="col-md-12">
                  <label for="details" class="form-label">Details </label>
                  <textarea class="form-control" name="details">@if(isset($MembershipPlan->details)){{$MembershipPlan->details}}@endif</textarea>
                </div>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

</div>
</div>
<!--end row-->
@endsection
