@extends('layouts.app')
@section('title','Publisher')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>Library Publisher</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Add New Publisher</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('publishers.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class=" shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width" action="{{route('publishers.store')}}" class="ajaxformfileupload" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @csrf

            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Publisher</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                     <label for="fname" class="form-label">Publisher Name <span class="text-danger"><b>*</b></span></label>
                     <div class="input-group has-validation"> <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-people"></i></span>
                      <input type="text" class="form-control" name="name" id="fname" placeholder="Publisher Name" required="">
                      @if ($errors->has('name'))
                      <span class="text-danger">{{ $errors->first('name') }}</span>
                      @endif
                    </div>
                  </div>
                  <div class="col-md-12">
                   <label for="fname" class="form-label">Publisher Phone <span class="text-danger"><b></b></span></label>
                   <div class="input-group has-validation"> <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-phone"></i></span>
                    <input type="number" class="form-control" name="phone" id="fname" placeholder="Phone">
                    @if ($errors->has('phone'))
                    <span class="text-danger">{{ $errors->first('phone') }}</span>
                    @endif
                  </div>
                </div>
                <div class="col-md-12">
                 <label for="fname" class="form-label">Publisher Email <span class="text-danger"><b></b></label>
                   <div class="input-group has-validation"> <span class="input-group-text" id="inputGroupPrepend">@</span>
                    <input type="email" class="form-control" name="email" id="fname" placeholder="Email" >
                    @if ($errors->has('email'))
                    <span class="text-danger">{{ $errors->first('email') }}</span>
                    @endif
                  </div>
                </div>
                <div class="col-md-12">
                  <label class="form-label">Place <span class="text-danger"><b></b></span></label>
                  <select class="form-control" id="country" name="place_id" >
                    <option value=" "> Select Place</option>
                    @foreach($places as $list)
                    <option value="{{ $list->id}}">{{$list->place}}</option>
                    @endforeach
                  </select>
                  @if ($errors->has('place_id'))
                  <span class="text-danger">{{ $errors->first('place_id') }}</span>
                  @endif
                </div>
                <div class="col-12" align="center">
                  <div class="d-grid gap-2 with-50">
                    <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Save Data</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-sm-12">
          <div class="card">
            <div class="card-body">
              <div class="g-3 row">
                <h5 class="mb-0">Publisher Image</h5>
                <hr class="mb-0">
                <div class="col-md-12">
                  <label for="name" class="form-label">Logo Image (Size 2000 KB)</label>
                  <input type="file" class="form-control" name="logo" id="name">
                  @if ($errors->has('logo'))
                  <span class="text-danger">{{ $errors->first('logo') }}</span>
                  @endif
                </div>
                <div class="col-md-6">
                  <div class="form-check form-switch form-switch-lg">
                    <input class="btn-lg form-check-input" type="checkbox" id="flexSwitchCheckDefault" name="isfeatured"  >
                    Is Featured
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-check form-switch form-switch-lg">
                    <input class="btn-lg form-check-input" type="checkbox" id="flexSwitchCheckDefault" name="website_view" >
                    Website View
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

</div>
</div>
<!--end row-->
@endsection
