@extends('layouts.app')
@section('title','Edit Stream')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>Library Stream</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Edit Stream</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('stream.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width" action="{{route('stream.update',$stream->id)}}" class="ajaxformfileupload" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @csrf
            @method('PUT')
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Stream</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <input type="hidden" name="id" value="@if(isset($stream->id) && $stream->id!=''){{$stream->id}}@endif">
                      <label for="stream_name" class="form-label">Stream Name <span class="text-danger"><b>*</b></span></label>
                      <input type="text" class="form-control" name="stream_name" id="stream_name" placeholder="Stream Name" value="@if(isset($stream->stream_name) && $stream->stream_name!=''){{$stream->stream_name}}@endif" required="">
                      @if ($errors->has('stream_name'))
                      <span class="text-danger">{{ $errors->first('stream_name') }}</span>
                      @endif
                    </div>
                    <div class="col-md-12">
                      <label for="stream_details" class="form-label">Stream Details <span class="text-danger"><b>*</b></span></label>
                      <textarea class="form-control" name="stream_details" placeholder="Description" required="">@if(isset($stream->stream_details) && $stream->stream_details!=''){{$stream->stream_details}}@endif</textarea>
                      @if ($errors->has('stream_details'))
                      <span class="text-danger">{{ $errors->first('stream_details') }}</span>
                      @endif
                    </div>

                    <div class="col-12" align="center">
                      <div class="d-grid gap-2">
                        <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Save Data</button>
                      </div>
                    </div>
                  </div>

                </div>
              </div>
            </div>

            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Stream Images</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                    <label for="icon" class="form-label">Icons <span class="text-danger">*</span> Please Use This Link(<a href="https://fontawesome.com/" target="_blank">Font Awesome</a>) </label>
                    <input type="text" class="form-control" name="icon" id="icon" placeholder="ex. fa-solid fa-bowl-food " value="{{$stream->icon}}">
                    @if ($errors->has('icon'))
                    <span class="text-danger">{{ $errors->first('icon') }}</span>
                    @endif
                  </div>
                    <div class="col-md-12">
                      <label for="name" class="form-label">Cover Small Image (Size 200 KB)</label>
                      <input type="file" class="form-control" name="cover_image_small" id="name" placeholder="Name">
                      @if ($errors->has('cover_image_small'))
                      <span class="text-danger">{{ $errors->first('cover_image_small') }}</span>
                      @endif
                    </div>
                    <div class="col-md-12">
                      <label for="name" class="form-label">Cover Large Image (Size 200 KB)</label>
                      <input type="file" class="form-control" name="cover_image_large" id="name" placeholder="Name">
                      @if ($errors->has('cover_image_large'))
                      <span class="text-danger">{{ $errors->first('cover_image_large') }}</span>
                      @endif
                    </div>
                    <div class="col-md-6">
                      <div class="form-check form-switch form-switch-lg">
                        <input class="btn-lg form-check-input" type="checkbox" id="flexSwitchCheckDefault" name="isfeatured"  @if($stream->isfeatured=='1'){{'checked'}}@endif> Is Featured
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-check form-switch form-switch-lg">
                        <input class="btn-lg form-check-input" type="checkbox" id="flexSwitchCheckDefault" name="website_view"  @if($stream->website_view=='1'){{'checked'}}@endif>  Website View
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>

      </div>
    </div>
    <!--end row-->
    @endsection
