@extends('layouts.app')
@section('title','Book Issue Update')
@section('pages')
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.2/bootstrap3-typeahead.min.js" ></script>
<style>
  .select2-selection__arrow
{
  display: none;
}
</style>
<!-- select 2 search link -->

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
<!--breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
  <div class="breadcrumb-title pe-3">Library Management</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">
        <li class="breadcrumb-item"><a href="{{ url('dashboard')}}"><i class="bx bx-home-alt"></i></a></li>
        <li class="breadcrumb-item active" aria-current="page">Edit Book Issue</li>
      </ol>
    </nav>
  </div>
  <div class="ms-auto">
    <div class="btn-group">
      <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
    </div>
  </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width" action="{{route('book-issue.update',$bookIssue->id)}}" class="ajaxformfileupload" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @csrf
            @method('PUT')
            <div class="col-md-4 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Book Issue</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <label> Issue Date</label>
                      <input type="text" class="form-control datepicker" placeholder="issue_date" aria-label="issue_date" name="issue_date" value="@if(isset($bookIssue->issue_date)){{date('Y-m-d',strtotime($bookIssue->issue_date))}}@endif">
                    </div>
                    <div class="col-md-12">
                      <label> Student (Roll No/Admission No/Name)<span class="text-danger">*</span></label>
                      <select class="livesearch form-control" name="student_name">
                        <option value="{{$bookIssue->getStudentDetails->id}}" selected>@if(isset($bookIssue->getStudentDetails->firstname)){{$bookIssue->getStudentDetails->firstname}} {{$bookIssue->getStudentDetails->lastname}}@endif</option>
                      </select>
                      <!-- <input type="text" class="form-control" id="search" placeholder="Student Name" aria-label="Student Name" name="student_name" value="@if(isset($bookIssue->getStudentDetails->firstname)) {{$bookIssue->getStudentDetails->firstname}} {{$bookIssue->getStudentDetails->lastname}}@endif"> -->
                    </div>
                    <div class="col-md-12">
                      <label> Books (ISBN No/Book Title)<span class="text-danger">*</span></label>
                      <select class="livebooks form-control" id="books"></select>
                      @if ($errors->has('book_name'))
                      <span class="text-danger">{{ $errors->first('book_name') }}</span>
                      @endif
                    </div>
                    <div class="d-grid gap-2">
                      <button class="btn btn-success mt-3" type="button" onclick="addmore()"> <i class="bi bi-cart-check-fill"></i> Add To Cart</button>
                    </div>
                </div>
              </div>
            </div>
          </div>

          <div class="col-md-8 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Book Issue</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                    <table class="table table-bordered mb-0">
                      <thead>
                      <tr>
                        <th>Book Name</th>
                        <th>Quantity</th>
                        <th>Action</th>
                      </tr>
                      </thead>
                      <tbody id="bookslist">
                        @if(count($bookIssue->issueDetails)>0)
                        @foreach($bookIssue->issueDetails as $key=> $list)
                        @php $key++;@endphp
                        <tr id="rows{{$key}}">
                        <input type="hidden" class="form-control" name="book_issue_details_id[]" id="book_issue_details_id{{$key}}" value="@if(isset($list->id)){{$list->id}}@endif">
                          <td><input type="text" class="form-control" value="@if(isset($list->book->book_title)){{$list->book->book_title}}@endif" readonly>
                            <input type="hidden" class="form-control" name="book_name[]" value="@if(isset($list->book->id)){{$list->book->id}}@endif" readonly></td>
                          <td><input type="text" class="form-control" name="qnt[]" value="@if(isset($list->qnt)){{$list->qnt}}@endif"></td>
                          <td>
                            <a  class="btn btn-danger btn-sm deletebookData" data-bs-toggle="tooltip" data-id="{{$key}}"  data-url="{{ route('deletebookitem') }}" data-mainid="{{$list->id}}" ><i class="bi bi-trash"></i></a>
                          </td>
                        </tr>
                        @endforeach
                        @endif

                      </tbody>
                    </table>
                  </div>
                  
                  <div class="col-12" align="center">
                    <div class="d-grid gap-2 top-0 start-50 with-50">
                      <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Submit To Issue Book</button>
                    </div>
                    </div>
                  </div>
                </div>
              </div>
          </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>



<script>
    var loopCount=50;
    function addmore()
    {
      var blank='';
      var student=$('#search').val();
      if(student=='')
      {
        $('#student').html('Please select Student');
        return false;
      }
      else
      {
        
        $('#student').html(blank);
      }


      var books=$('#books').val();
      const myArray = books.split(",");
      if(books=='')
      {
        $('#books').html('Please select Books');
        return false;
      }
      else
      {
        $('#books').html(blank);
      }
      
      
        loopCount++;
        var new_item='<tr id="rows'+loopCount+'">\
        <input type="hidden" class="form-control" name="book_issue_details_id[]" value=" ">\
        <td><input type="text" class="form-control" value="'+myArray[1]+'" readonly>\
        <input type="hidden" class="form-control" name="book_name[]" value="'+myArray[0]+'" readonly></td>\
        <td><input type="text" class="form-control" name="qnt[]" value="1"></td>\
        <td>\
            <a  class="btn btn-danger btn-sm deletebookData" data-bs-toggle="tooltip" data-id="'+loopCount+'"><i class="bi bi-trash"></i></a>\
        </td>\
</tr>';
$('#bookslist').append(new_item);
        loopCount++;
        $('#books').val(blank);
    }
    function remove(ids) 
    {

      let id=$('#book_issue_details_id'+ids).val();
      if(id)
      {
          $.ajax({
                  type: "POST",
                  url: "{{ route('deletebookitem') }}",
                  data: {id:id},
                  success: function (data) {
                  },
                  error: function (data) {
                      console.log(data);
                  }
              });
              $('#rows' + ids).remove();
      }
      else
      {
          $('#rows' + ids).remove();
      }


    }
    </script>

<script type="text/javascript">
    $('.livesearch').select2({
        placeholder: 'Search Student (Roll No/Admission No/Name)',
        ajax: {
            url: "{{ route('autocomplete.studentssearch') }}",
            dataType: 'json',
            delay: 250,
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.name +'('+item.class_name+')',
                            id: item.id
                        }
                    })
                };
            },
            cache: true
        }
    });
</script>
<script type="text/javascript">
        // var routes = "{{ route('autocomplete.bookssearch') }}";
        // $('#books').typeahead({
        //     source: function (query, process) {
        //         return $.get(routes, {
        //             query: query
        //         }, function (data) {
        //             return process(data);
        //         });
        //     }
        // });
    //     $('.livebooks').select2({
    //     placeholder: 'Search Books (ISBN No/Book Title)',
    //     minimumInputLength: 3,
    //     ajax: {
    //         url: "{{ route('autocomplete.bookssearch') }}",
    //         dataType: 'json',
    //         delay: 250,
    //         processResults: function (data) {
    //             return {
    //                 results: $.map(data, function (item) {
    //                     return {
    //                         text: item.name,
    //                         id: item.id+','+item.name,
    //                     }
    //                 })
    //             };
    //         },
    //         cache: true
    //     }
    // });



   $(document).ready(function() {
            var select2Input = $('.livebooks');

            select2Input.select2({
                ajax: {
                    url: "{{ route('autocomplete.bookssearch') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            q: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        return {
                          results: $.map(data, function (item) {
                        return {
                            text: item.name,
                            id: item.id+','+item.name,
                        }
                        
                    })
                        };
                    },
                    cache: true
                },
                placeholder: 'Search Book (ISBN No/Book Title)',
                minimumInputLength: 3 // Minimum number of characters before making the AJAX call
            });

            // Capture Enter key press event on the Select2 input
            select2Input.on('select2:open', function () {
                var searchBox = $('.select2-search__field');

                searchBox.on('keydown', function (e) {
                    if (e.keyCode === 13) {
                        // Prevent the default form submission
                        e.preventDefault();
                        addmore();

                        // Get the selected value
                        var selectedValue = select2Input.val();

                        // Do something with the selected value
                        console.log('Selected value:', selectedValue);
                        // Add your custom code to handle the Enter key press event

                        // Close the Select2 dropdown after the Enter key is pressed
                        select2Input.select2('close');
                    }
                });
            });
        });
    </script>
<!--end row-->
@endsection