@extends('layouts.app')
@section('title','Book Issue Details')
@section('pages')



<!--breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Books</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item"><a href="{{ url('dashboard')}}"><i class="bx bx-home-alt"></i></a></li>
                <li class="breadcrumb-item active" aria-current="page">Book Issue Details</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class="shadow-none radius-5 min-height">
            <div class="row" id="print_div">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body g-3">
                            <div class="row">
                                <div class="col-md-12">
                                    <h4>META MINT PRIVATE LIMITED</h4>
                                    <p>GSTIN : 16AAPCM6673H1ZX, PAN: AAPCM6673H<br>
                                    ADDRESS : MBB College Road, Near Shib Nagar Modern Club, West Tripura, Agartala, Pin: 799001<br>
                                    STATE : TRIPURA (16) - INDIA<br>
                                    MOBILE : 9774515847, 9366744376<br>
                                    EMAIL : metamintindia@gmail.com, Website: https://metamintindia.com, CIN-U72900TR2022PTC014080</p>
                                </div>
                            </div>
                                <table class="table table-bordered align-middle" style="width:100%">

                                    <tr>
                                        <td><p><b>INVOICE DATE : @if(isset($bookIssue->issue_date)) {{$bookIssue->issue_date}}@endif </b></p></td>
                                        <td><p><b>INVOICE NO : @if(isset($bookIssue->issue_no)) {{$bookIssue->issue_no}}@endif  </b></p></td>
                                        <td><p><b>PAYMENT TERMS : CREDIT</b></p></td>
                                    </tr>
                                    <tr>
                                        <td>Member (Bill To) :@if(isset($bookIssue->getStudentAllDetails->firstname)) {{$bookIssue->getStudentAllDetails->firstname}} {{$bookIssue->getStudentAllDetails->lastname}}@endif<br>
                                            <br>
                                            PHONE NO :@if(isset($bookIssue->getStudentAllDetails->mobileno)) {{$bookIssue->getStudentAllDetails->mobileno}}@endif<br>
                                            EMAIL ID :@if(isset($bookIssue->getStudentAllDetails->email)) {{$bookIssue->getStudentAllDetails->email}}@endif<br>
                                            BILL TO ADDRESS :@if(isset($bookIssue->getStudentAllDetails->current_address)) {{$bookIssue->getStudentAllDetails->current_address}}@endif<br>
                                        </td>
                                        <td>Reff No. :@if(isset($bookIssue->getStudentAllDetails->admission_no)) {{$bookIssue->getStudentAllDetails->admission_no}}@endif<br>
                                            Delivery Date : 27-06-2023<br>
                                            Delivery<br>
                                            Agent<br>
                                        </td>
                                        <td>{!! $borcode !!}
                                            <br>
                                            {{$bookIssue->issue_no}}
                                        </td>

                                    </tr>
                                     </table>
                                     <table class="table table-bordered align-middle" style="width:100%">
                                    <tr><td colspan="4" align="center"><b class="h4">Book Details</b></td></tr>

                                    <tr>
                                        <th>Sl No</th>
                                        <th>Title</th>
                                        <th>ISBN NO</th>
                                        <th>Publisher</th>
                                        <th>Laguages</th>
                                    </tr>
                                    @if(count($bookIssue->issueDetails)>0)
                                    @foreach($bookIssue->issueDetails as $key=> $list)
                                    @php $key++; @endphp

                                    <tr>
                                        <td>{{$key}}</td>
                                        <td style="width: 1%;white-space:nowrap;">@if(isset($list->book->book_title)){{$list->book->book_title}}@endif<br>
                                        @if(isset($list->book->author->first_name))
                                        <b>Author:
                                        {{$list->book->author->first_name}}</b>

                                        @endif
                                        </td>
                                        <td>@if(isset($list->book->isbn_no)){{$list->book->isbn_no}}@endif</td>

                                        <td>@if(isset($list->book->publisher->name)){{$list->book->publisher->name}}@endif</td>
                                        <td>@if(isset($list->book->languages->lang_name)){{$list->book->languages->lang_name}}@endif</td>
                                    </tr>
                                    @endforeach
                                    @endif

                                </table>
                                <input type="hidden" name="" id="page_title" value="INVOICE NO : @if(isset($bookIssue->issue_no)) {{$bookIssue->issue_no}}@endif">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12" align="center">
                      <button class="btn btn-primary mt-3 btn_print" id="btn_print"><i class="bi bi-printer text-white"></i> Print Invoice</button>
                      <button class="btn btn-primary mt-3" id="btn_pdf"><i class="bx bx-save"> Downloads</i></button>
                    </div>


                </div>
            </div>
        </div>
    </div>
    <link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
    <script src="{{ asset('admin/js/html2canvas.min.js')}}"></script>
    <script src="{{ asset('admin/js/jspdf.min.js')}}"></script>
    <script src="{{ asset('admin/js/printThis.js')}}"></script>
    <script>
    function printa() {
        window.print();
        setInterval(function() { location.href="{{url('library/book-issue')}}";}, 1000);

    }
</script>

<script>
$(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $('#btn_print').click(function(event) {
             ;
            event.preventDefault();
            PrintPanel();
        });

        $('#btn_pdf').click(function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 240;
                    var imgHeight = (canvas.height * 48) / 240;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });
    function PrintPanel()
    {
        var prtContent = document.getElementById("print_div");
        var WinPrint = window.open('', '', 'height=750px,width=960px');
        var page_title = $('#page_title').val();
        WinPrint.document.write('<html><head><Title>'+page_title+'</Title>');
        WinPrint.document.write('</head><body>');
        WinPrint.document.write('<style>table, th, td {border: 1px solid;}table {width: 100%;border-collapse: collapse;}</style>');
         WinPrint.document.write(prtContent.innerHTML);
        WinPrint.document.write('</body></html>');
        WinPrint.document.close();
        WinPrint.focus();
        WinPrint.print();
        WinPrint.close();

    }
</script>
    <!--end row-->
    @endsection
