@extends('layouts.app')
@section('title','Book Request Details')
@section('pages')

<style>
    .checkbox {
        display: block !important;
    }

    .ui-switcher {
        display: none !important;
    }

    .select2-selection__arrow {
        display: none;
    }
</style>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Book Request</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Book Request Details</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class="shadow-none radius-5 min-height">
            <div class="row" id="print_div">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body row g-3">
                            <div class="row">
                                <div class="col-md-12">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <table class="table table-bordered align-middle" style="width:100%">
                                    <tr>
                                        <td>
                                            <p><b>Request DATE : @if(isset($BookRequest->order_date)) {{date('d-m-Y',strtotime($BookRequest->order_date))}}@endif </b></p>
                                        </td>
                                        <td>
                                            <p><b>Request NO : @if(isset($BookRequest->order_no)) {{$BookRequest->order_no}}@endif </b></p>
                                        </td>
                                        <td>
                                            <p><b>Admission No : @if(isset($BookRequest->getStudents->unique_register_no)) {{$BookRequest->getStudents->unique_register_no}}@endif</b></p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Member (Bill To) :@if(isset($BookRequest->getStudents->name)) {{$BookRequest->getStudents->name}} {{$BookRequest->getStudents->lastname}}@endif
                                            PHONE NO :@if(isset($BookRequest->getStudents->account_contact->phone_no)) {{$BookRequest->getStudents->account_contact->phone_no}}@endif<br>
                                        </td>
                                        <td>EMAIL ID :@if(isset($BookRequest->getStudents->account_contact->email)) {{$BookRequest->getStudents->account_contact->email}}@endif<br>
                                        </td>
                                        <td>
                                            BILL TO ADDRESS :@if(isset($BookRequest->getStudents->first_account_address->address_line1)) {{$BookRequest->getStudents->first_account_address->address_line1}}@endif
                                        </td>

                                    </tr>
                                </table>
                            </div>
                            @php $TotalIssueBook=sumIssueBooks($BookRequest->getStudents->id);
                            $limitBooks=bookLimit($BookRequest->getStudents->id,$financialYears->financialyearid);
                            @endphp
                            <div class="col-md-12">
                                <p class="text-success h4">Available Book Limit is <span class="text-danger mark">(@if(($limitBooks-$TotalIssueBook)>0){{$checks=$limitBooks-$TotalIssueBook}}@else{{$checks='0'}}@endif)</span></p>
                                <form method="POST" class="ajaxformfileupload row" action="{{route('book-request.store-status')}}" enctype='multipart/form-data'>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered align-middle" border="1" style="width:100%">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th class="thbutton">#</th>
                                                        <th>Title</th>
                                                        <th>Quantity</th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($BookRequest->getRequestDetail)>0)
                                                    @foreach($BookRequest->getRequestDetail as $key=> $list)
                                                    @php $key++; @endphp
                                                    <tr>
                                                        <td><input type="checkbox" class="checkbox" name="request_detail_id[]" value="{{$list->id}}"></td>
                                                        <td>
                                                            <i class="bi bi-book text-info"></i>
                                                            @if(isset($list->getBook->short_name)){{$list->getBook->short_name}}@endif<br>

                                                            @if(isset($list->getBook->author->first_name))
                                                            <i class="bi bi-pencil-square text-info"></i>
                                                            {{$list->getBook->author->first_name}}
                                                            @endif

                                                        </td>
                                                        <td>@if(isset($list->qnt)){{$list->qnt}}@endif</td>
                                                    </tr>
                                                    @endforeach
                                                    @endif
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="row">
                                        <div class="col-md-3">
                                            <label>Status </label>
                                            <input type="hidden" name="request_id" value="{{$BookRequest->id}}">
                                            <select class="single-select" name="status">
                                                <option value=" ">Please Select Status</option>
                                                @if(isset($checks) && $checks!=0)
                                                <option value="Accept">Accept</option>
                                                @endif
                                                <option value="Cancelled">Cancel</option>
                                            </select>
                                        </div>
                                        <div class="col-md-9  mt-3">
                                            <div class="d-grid gap-2 start-50">
                                                <button class="btn btn-primary btn-lg" type="submit"><i class="bx bx-save"></i> Submit</button>
                                            </div>
                                        </div>

                                    </div>
                                    </div>
                                   
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>
</div>


<!--end row-->
@endsection