@extends('layouts.app')
@section('title','Book Returns')
@section('pages')
<style>
.checkbox{
  display:block !important;
}
.ui-switcher{
  display:none !important;
}
.select2-selection__arrow
{
  display: none;
}
  </style>

<!-- <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" /> -->
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>

<!--breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
  <div class="breadcrumb-title pe-3">Library Management</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">
        <li class="breadcrumb-item"><a href="{{ url('dashboard')}}"><i class="bx bx-home-alt"></i></a></li>
        <li class="breadcrumb-item active" aria-current="page">Book Returns</li>
      </ol>
    </nav>
  </div>
  <div class="ms-auto">
    <div class="btn-group">
      <a href="{{route('book-return.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
    </div>
  </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width" action="{{route('book-return.store')}}" class="ajaxformfileupload" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @csrf
            <div class="col-md-4 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Book Returns</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <label> Return Date</label>
                      <input type="text" class="form-control datepickerss" placeholder="Return Date" aria-label="return_date" name="return_date" value="{{date('Y-m-d')}}">
                    </div>
                    <div class="col-md-12">
                      <label> Student (Roll No/Admission No/Name)<span class="text-danger">*</span></label>
                      <div class="input-group autocomplete">
                        <input type="text" name="" class="studen-select form-control" placeholder="Student (Roll No/Admission No/Name)">
                        <input type="hidden" name="student_id" value="" id="student_id">
                      </div>
                      <span class="text-danger error_student_id" style="display:none;">This field is required.</span>

                      <!-- <select class="livesearch form-control" name="student_id" id="student_id"></select> -->
                    </div>

                    <div class="d-grid gap-2">
                    <button class="btn btn-success mt-3" type="button" onclick="getbooksData()"><i class="bi bi-search"></i> Search Books</button>
                    </div>


                </div>
              </div>
            </div>
          </div>
          <div class="col-md-8 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Book Returns</h5>
                    <hr class="mb-0">

                    <div class="col-md-12">
                      <div class="table-responsive">
                    <table class="table table-bordered mb-0">
                      <thead class="table-light">
                      <tr class="table-light">
                        <th><input type="checkbox" class="checkbox" id="selectAll"> All</th>
                        <th scope="col">Book Name</th>
                        <th scope="col">Return Qty</th>
                        <th scope="col">Damage Qty</th>
                        <th scope="col">Amount</th>
                        <th scope="col">Damage</th>

                      </tr>
                      </thead>
                      <tbody id="bookslist">

                      </tbody>
                    </table>
                    @if ($errors->has('book_issue_id'))
                      <span class="text-danger">{{ $errors->first('book_issue_id') }}</span>
                      @endif
                  </div>
                  </div>
                  <div class="col-md-12">
                      <label> Remark</label>
                      <textarea class="form-control" name="remark"></textarea>
                    </div>
                  <div class="col-12" align="center">
                  <div class="d-grid gap-2">
                      <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Submit To Book Return</button>
                    </div>
                  </div>
                  </div>
                </div>
              </div>
          </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<!-- <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.2/jquery-ui.min.js"></script>


<script>
    $("#selectAll").click(function () {
        $('.checkbox').not(this).prop('checked', this.checked);
    });

    function getbooksData()
    {
        let student_id=$('#student_id').val();

        $.ajax({
            type: "POST",
            url: "{{ route('return.returnBooksearch') }}",
            data: {student_id:student_id},
            success: function (data) {
                $('#bookslist').html(data);
            },
            error: function (data) {
                //console.log(data);
            }
        });
    }

    $('.studen-select').autocomplete({
            autoFocus: true,
            minLength: 0,
            source: function(request, response) {
                if (request.term.length < 2) {
                    $('[name="student_id"]').val('');
                    return false;
                }

                $.ajax({
                    url: "{{ route('autocomplete.studentssearch') }}",
                    type: 'GET',
                    dataType: 'json',
                    data: {
                        q: request.term
                    },
                    success: function(json) {
                      console.log(json.result);
                        if (json.error) {
                            $('[name="student_id"]').val('');
                            return false;
                        }
                        response($.map(json.result, function(item) {
                          //console.log(item);
                            return {
                                id: item.id,
                                name: item.name,
                                class_name: item.class_name,
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {
              console.log(ui);
                event.preventDefault();
                var class_name   = ui.item.class_name != null ? ', ' + ui.item.class_name : '';

                $(this).val(ui.item.name + class_name + "");
                $('[name="student_id"]').val(ui.item.id);
                return false;
            }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            var class_name   = item.class_name != null ? ', ' + item.class_name : '';
            return $("<li>")
                .append("<a>" + item.name + class_name + "</a>")
                .appendTo(ul);
        };
    </script>
<!--end row-->



@endsection
