@extends('layouts.app')
@section('title','Book Return Details')
@section('pages')

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Book Return</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Book Return Details</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class="shadow-none radius-5 min-height">
            <div class="row" id="print_div">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body g-3">
                            <div class="row">
                                <div class="col-md-12">
                                </div>
                            </div>

                                <table class="table table-bordered align-middle" style="width:100%">

                                    <tr>
                                        <td><p><b>INVOICE DATE : @if(isset($bookReturn[0]->return_no)) {{$bookReturn[0]->return_no}}@endif </b></p></td>
                                        <td><p><b>INVOICE NO : @if(isset($bookReturn[0]->return_no)) {{$bookReturn[0]->return_no}}@endif  </b></p></td>
                                        <td><p><b>PAYMENT TERMS : CREDIT</b></p></td>
                                    </tr>
                                    <tr>
                                        <td>Member (Bill To) :@if(isset($bookReturn[0]->getIssuedetails->getisseuBook->getStudentDetails->name)) {{$bookReturn[0]->getIssuedetails->getisseuBook->getStudentDetails->name}}@endif<br>
                                            <br>
                                            PHONE NO :@if(isset($bookReturn[0]->getIssuedetails->getisseuBook->getStudentDetails->account_contact->phone_no)) {{$bookReturn[0]->getIssuedetails->getisseuBook->getStudentDetails->account_contact->phone_no}}@endif<br>
                                            EMAIL ID :@if(isset($bookReturn[0]->getIssuedetails->getisseuBook->getStudentDetails->account_contact->email)) {{$bookReturn[0]->getIssuedetails->getisseuBook->getStudentDetails->account_contact->email}}@endif<br>
                                            BILL TO ADDRESS :@if(isset($bookReturn[0]->getIssuedetails->getisseuBook->getStudentDetails->first_account_address->address_line1)) {{$bookReturn[0]->getIssuedetails->getisseuBook->getStudentDetails->first_account_address->address_line1}}@endif<br>
                                        </td>
                                        <td>Reff No. :@if(isset($bookReturn[0]->getIssuedetails->getisseuBook->getStudentDetails->unique_register_no)) {{$bookReturn[0]->getIssuedetails->getisseuBook->getStudentDetails->unique_register_no}}@endif<br>
                                            Return Date : @if(isset($bookReturn[0]->return_date)) {{$bookReturn[0]->return_date}}@endif<br>
                                            Delivery Agent<br>
                                        </td>
                                        <td align="center">{!! $borcode !!}
                                            <br>
                                            {{$bookReturn[0]->return_no}}

                                        </td>

                                    </tr>
                                     </table>

                                     <table class="table table-bordered align-middle" style="width:100%">
                                    <tr><td colspan="7" align="center"><b class="h4">Book Details</b></td></tr>

                                    <tr>
                                        <th class="thbutton">Sl No</th>
                                        <th>Title</th>
                                        <th>ISBN NO</th>
                                        <th>Publisher</th>
                                        <th>Laguages</th>
                                        <th>Status</th>
                                        <th>Amount</th>
                                    </tr>
                                    @if(count($bookReturn)>0)
                                    @foreach($bookReturn as $key=> $list)
                                    @php $key++; @endphp

                                    <tr>
                                        <td>{{$key}}</td>
                                        <td>@if(isset($list->getIssuedetails->book->short_name)){{$list->getIssuedetails->book->short_name}}@endif<br>
                                        @if(isset($list->getIssuedetails->book->book_details->author))
                                        <b>Author:
                                        {{$list->getIssuedetails->book->book_details->author}}
                                        </b>
                                        @endif
                                        </td>
                                        <td>@if(isset($list->getIssuedetails->book->shortcode)){{$list->getIssuedetails->book->shortcode}}@endif</td>

                                        <td>@if(isset($list->getIssuedetails->book->book_details->publisher)){{$list->getIssuedetails->book->book_details->publisher}}@endif</td>
                                        <td>@if(isset($list->getIssuedetails->book->book_details->laguage)){{$list->getIssuedetails->book->book_details->laguage}}@endif</td>
                                        <td>
                                            <span class="badge p-2 h1 rounded-pill font-size-bolt text-white @if($list->damage_status==1){{'bg-danger'}}@else{{'bg-success'}}@endif" style="padding:3px">
                                            @if($list->damage_status==1){{'Damage'}}@else{{'No Damage'}}@endif</span>
                                        </td>

                                        <td>{{$list->amount}}</td>
                                    </tr>
                                    @endforeach
                                    @endif

                                </table>
                                <input type="hidden" name="" id="page_title" value="INVOICE NO : @if(isset($bookReturn[0]->return_no)) {{$bookReturn[0]->return_no}}@endif">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12" align="center">
                      <button class="btn btn-primary mt-3 btn_print" id="btn_print"><i class="bi bi-printer text-white"></i> Print Invoice</button>
                      <button class="btn btn-primary mt-3" id="btn_pdf"><i class="bx bx-save"> Downloads</i></button>
                    </div>


                </div>
            </div>
        </div>
    </div>
    <link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
    <script src="{{ asset('admin/js/html2canvas.min.js')}}"></script>
    <script src="{{ asset('admin/js/jspdf.min.js')}}"></script>
    <script src="{{ asset('admin/js/printThis.js')}}"></script>
    <script>
    function printa() {
        window.print();
        setInterval(function() { location.href="{{url('library/book-issue')}}";}, 1000);

    }
</script>

<script>
$(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $('#btn_print').click(function(event) {
             ;
            event.preventDefault();
            PrintPanel();
        });

        $('#btn_pdf').click(function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 240;
                    var imgHeight = (canvas.height * 48) / 240;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });
    function PrintPanel()
    {
        var prtContent = document.getElementById("print_div");
        var WinPrint = window.open('', '', 'height=750px,width=960px');
        var page_title = $('#page_title').val();
        WinPrint.document.write('<html><head><Title>'+page_title+'</Title>');
        WinPrint.document.write('</head><body>');
        WinPrint.document.write('<style>table, th, td {border: 1px solid;}table {width: 100%;border-collapse: collapse;}</style>');
         WinPrint.document.write(prtContent.innerHTML);
        WinPrint.document.write('</body></html>');
        WinPrint.document.close();
        WinPrint.focus();
        WinPrint.print();
        WinPrint.close();

    }
</script>
    <!--end row-->
    @endsection
