@extends('layouts.app')
@section('title','New Card Issue')
@section('pages')
<style>
.checkbox{
  display:block !important;
}
.ui-switcher{
  display:none !important;
}
  </style>

<!--breadcrumb-->


<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Card Issue</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">New Card Issue</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('cards.index')}}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="row">

            <!-- For validation comment on -->
            <form action="{{route('cards.store')}}" class="librarycardAjax" method="POST">
            <div class="col-md-12 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Library Card</h5>
                    <hr class="mb-0">
                  <div class="col-md-3">
                     <label for="membership_id" class="form-label">Membership Plan<span class="text-danger"><b>*</b></span></label>
                      <select class="single-select" name="membership_id" id="membership_id">
                        <option value=" ">--select---</option>
                        @foreach($membershiplan as $membership)
                        <option value="{{$membership->id}}">{{$membership->name}}</option>
                        @endforeach
                      </select>
                      @if ($errors->has('membership_id'))
                      <span class="text-danger">{{ $errors->first('membership_id') }}</span>
                      @endif
                  </div>
                    <div class="col-md-3">
                     <label for="Acadmic Year" class="form-label">Acadmic Year <span class="text-danger"><b>*</b></span></label>
                      <select class="single-select" name="financial_id" id="financial_id">
                        <option value=" ">--select---</option>
                        @foreach($academic as $academic)
                        <option value="{{$academic->financialyearid}}">{{$academic->financial_year_name}}</option>
                        @endforeach
                      </select>
                      @if ($errors->has('financial_id'))
                      <span class="text-danger">{{ $errors->first('financial_id') }}</span>
                      @endif
                  </div>
                  <div class="col-md-3">
                     <label for="Acadmic Year" class="form-label">Class <span class="text-danger"><b>*</b></span></label>
                      <select class="single-select class_id" name="class_id" id="class_id" onchange="getsection()">
                        <option value=" ">--select---</option>
                        @foreach($classes as $clas)
                        <option value="{{$clas->id}}">{{$clas->class_name}}</option>
                        @endforeach
                      </select>
                      @if($errors->has('class_id'))
                      <span class="text-danger">{{ $errors->first('class_id') }}</span>
                      @endif
                  </div>
                  <div class="col-md-3">
                     <label for="Acadmic Year" class="form-label">Section <span class="text-danger"><b>*</b></span></label>
                      <select class="single-select section_id" name="section_id" id="section_id">

                      </select>
                      @if($errors->has('section_id'))
                      <span class="text-danger">{{ $errors->first('section_id') }}</span>
                      @endif
                  </div>
                  <div class="col-12">
                    <button class="btn btn-primary" type="button" onclick="getStudentData()"><i class="bi bi-search"></i> Search Member</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-12 col-sm-12">
            <div class="card">
              <div class="card-body">
                <div class="g-3 row">
                  <h5 class="mb-0">Library Card</h5>
                  <hr class="mb-0">
                  <div class="col-md-12">

                   <div class="table-responsive">
                     <table class="table table-bordered align-middle">
                      <tr>
                        <th><input type="checkbox" class="checkbox" id="selectAll"> All</th>
                        <th>Name</th>
                        <th>Admission No</th>
                      </tr>
                      <tbody id="tbody">

                      </tbody>

                     </table>
                   </div>
                   <div class="col-12" align="center">
                   <div class="d-grid gap-2 top-0 start-50 with-50">
                   <button type="submit" class="btn btn-success mt-3"><i class="bx bx-save"></i> Issue Library Card </button>
                   </div>
                   </div>
                  </div>

                </div>
              </div>
            </div>
          </div>
          </form>
      </div>
    </div>
  </div>

</div>
</div>
<!--end row-->
<script>

function getsection()
{
    var classId=$('#class_id').val();

    $.ajax({
            url:"{!! route('class.sections') !!}",
            // data: formdata,
            /*processData: false,
            contentType: false,*/
            type: 'GET',
            data: {'class': classId},
            success:function(response) {
                if (response.success == false) {
                    toastr.error(response.message, 'Error!');
                }

                if (response.success == true && response.data && response.data != '') {
                    var options = ``;
                    $.each(response.data, function(index, record) {
                        options += `<option value="` + record.academics_section_id + `">` + record.section + `</option>`;
                    });

                    $(".section_id").html(options);

                    $('.section_id').select2({
                        theme: 'bootstrap4',
                        width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                        placeholder: $(this).data('placeholder'),
                        allowClear: Boolean($(this).data('allow-clear')),
                    });

                    // toastr.success(response.message, 'Success.');
                } else {
                    $(".section_id").html('');
                }
            }
        }).fail(function(jqXHR, textStatus, errorThrown) {
            toastr.error('An error occurred during the request.', 'Error!');
        });
}



function getStudentData()
{
  var class_id=$('#class_id').val();
  var section_id=$('#section_id').val();
  var financial_id=$('#financial_id').val();
     $.ajax({
        type: "POST",
        url: "{{ route('cards.getstudent') }}",
        data: {class_id:class_id,section_id:section_id,financial_id:financial_id},
        success: function (data) {
            $('#tbody').html(data);
        },
        error: function (data) {
            //console.log(data);
        }
    });
}
$("#selectAll").click(function () {
        $('input:checkbox').not(this).prop('checked', this.checked);
    });


</script>
@endsection
