@extends('layouts.app')
@section('title','Library Card')
@section('pages')
<style>

</style>

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Card Issue</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Library Card</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>

<!--end breadcrumb-->
  <!--start wrapper-->
  <div class="row auto">
    <div class="col-xl-12 mx-auto" id="print_div">
        <div class="shadow-none radius-5 min-height">
            <div class="row" >
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body g-3">
                            <div class="row rows">
                                <div class="col-md-6 item1">
                                    <h5 class="mb-0">Card No.:{{$card_no}} </h5>
                                    <img src="@if(isset($profile_pic)){{getTempUrl($profile_pic)}}@endif" width="150" height="150" class="mt-2">
                                    <p>
                                    {!! $borcode !!}
                                    </p>
                                </div>
                                <div class="col-md-6 item2">
                                    <p> {{$firstname}}<br>
                                    <b>{{getComapnyName()->name??''}}</b>
                                    <br>
                                    <br>
                                    <b>
                                    L I B R A R Y C A R D
                                    </b>
                                    <br>

                                    Admission No:-{{$admission_no}}
                                    <br>
                                    Class
                                    -
                                    {{$class_name}}

                                    ({{$academics_section_id}})
                                    <br>
                                    Date of Issue : {{$date_of_issue}}
                                    <br>
                                    Valid upto : {{$valid_upto}}
                                    </p>

                                </div>
                                <input type="hidden" id="page_title" value="Card No {{$card_no}}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
  </div>
  <div class="container">
    <div class="row">
        <div class="col-md-12" align="center">
            <button class="btn btn-primary mt-3 btn_print" id="btn_print"><i class="bi bi-printer text-white"></i> Print Invoice</button>
            <button class="btn btn-primary mt-3" id="btn_pdf"><i class="bx bx-save"> Downloads</i></button>
        </div>
    </div>

  </div>
  <link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
    <script src="{{ asset('admin/js/html2canvas.min.js')}}"></script>
    <script src="{{ asset('admin/js/jspdf.min.js')}}"></script>
    <script src="{{ asset('admin/js/printThis.js')}}"></script>
  <script>
$(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $('#btn_print').click(function(event) {
             ;
            event.preventDefault();
            PrintPanel();
        });

        $('#btn_pdf').click(function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 240;
                    var imgHeight = (canvas.height * 48) / 240;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });
    function PrintPanel()
    {
        var prtContent = document.getElementById("print_div");
        var WinPrint = window.open('', '', 'height=750px,width=960px');
        var page_title = $('#page_title').val();
        WinPrint.document.write('<html><head><Title>'+page_title+'</Title>');
        WinPrint.document.write('</head><body>');
        WinPrint.document.write('<style> .item1 { grid-area: 1 / 1 / 2 / 2; }.item2 { grid-area: 1 / 2 / 2 / 3; }.rows {display: grid;grid-auto-rows: 150px;\
  grid-gap: 10px;\
  padding: 10px;}\
.rows > div {\
  text-align: center;\
  padding: 20px 0;\
}</style>');
         WinPrint.document.write(prtContent.innerHTML);
        WinPrint.document.write('</body></html>');
        WinPrint.document.close();
        WinPrint.focus();
        WinPrint.print();
        WinPrint.close();

    }
</script>

@endsection
