@extends('layouts.app')
@section('title','New Book (Bulk)')
@section('pages')
<style>
  .autocompelteli {
    margin-left: 10px;
  }

  .select2-selection__arrow {
    display: none;
  }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
  <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>Book</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">

        <li class="breadcrumb-item active" aria-current="page">New Book (Bulk)</li>
      </ol>
    </nav>
  </div>
  <div class="ms-auto">
    <div class="btn-group">
      <a href="{{route('books.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
    </div>
  </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('store-book.bulk')}}" method="post" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            <div class="col-md-12 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <div class="col-md-6">
                      <h5 class="mb-0">New Book (Bulk)</h5>
                    </div>
                    <div class="col-md-6">
                      <a class="float-end btn btn-outline-primary" href="{{route('book-bulk-list')}}"><i class="bi bi-cart-check-fill"></i> Book Cart List ({{$totalTempBook??0}})</a>
                    </div>
                    <hr class="mb-0">
                    <div class="col-md-6">
                      <label> Books (ISBN No)<span class="text-danger">*</span></label>
                      <input type="text" placeholder="Search Book (ISBN No)" class="form-control" id="books" onkeypress="handleEnter(event)">
                      @if ($errors->has('book_name'))
                      <span class="text-danger">{{ $errors->first('book_name') }}</span>
                      @endif
                    </div>
                    <div class="col-md-6">
                      <div class="d-grid gap-2">
                        <button class="btn btn-outline-success mt-3 btn-lg" type="button" onclick="addmore()"> <i class="bi bi-cart-check-fill"></i> Add To Cart</button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-12 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Books</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                      <div class="table-responsive">
                        <table class="table table-bordered mb-0">
                          <thead class="table-light">
                            <tr class="table-light">
                              <th scope="col">ISBN NO</th>
                              <th scope="col">Book Title</th>
                              <th scope="col">Author</th>
                              <th scope="col">Publisher</th>
                              <th scope="col">No of Pages</th>
                              <th scope="col">Physical Format</th>
                              <th scope="col">Publish Date</th>
                              <th scope="col">Book Type</th>
                              <th scope="col">Status</th>
                              <th scope="col">Action</th>
                            </tr>
                          </thead>
                          <tbody id="bookslist">

                          </tbody>
                        </table>
                      </div>
                      <div class="col-12" align="center">
                        <div class="d-grid gap-2 top-0 start-50 with-50">
                          <button class="btn btn-primary mt-3" type="submit"><i class="bx bx-save"></i> Submit Book to Bulk Upload</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
        </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>


<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add New Books</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form class="form-group" id="manualform">
          <div class="row">
            <div class="col-md-12">
              <label>Book Title</label>
              <input type="hidden" id="mid">
              <input type="text" class="form-control" id="mbooktitle" value="" placeholder="Book Title">
            </div>
            <div class="col-md-6">
              <label>Author</label>
              <input type="text" class="form-control" id="mauthor" value="" placeholder="Author">
            </div>
            <div class="col-md-6">
              <label>Publisher</label>
              <input type="text" class="form-control" id="mpublisher" value="" placeholder="Publisher">
            </div>
            <div class="col-md-6">
              <label>No of Pages</label>
              <input type="text" class="form-control" id="mpages" value="" placeholder="No of Pages">
            </div>
            <div class="col-md-6">
              <label>Book Formate</label>
              <input type="text" class="form-control" id="mformate" value="" placeholder="Book Formate">
            </div>
            <div class="col-md-6">
              <label>Edition</label>
              <input type="text" class="form-control" id="medition" value="" placeholder="Edition">
            </div>
            <div class="col-md-6">
              <label>MRP</label>
              <input type="text" class="form-control" id="mmrp" value="" placeholder="Mrp">
            </div>
            <div class="col-md-6">
              <label>Quantity</label>
              <input type="text" class="form-control" id="mqty" value="" placeholder="Quantity">
            </div>
            <div class="col-md-6">
              <label>Publish Date</label>
              <input type="text" class="form-control" id="mpublish" value="" placeholder="Publish">
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer row">
        <div class="col-md-12">
          <div class="d-grid gap-2 top-0 start-50">
            <button type="button" class="btn btn-primary" onclick="savebook()" fdprocessedid="c4zsrr"><i class="bx bx-save"></i> Save</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>

<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
<script>
  function handleEnter(event) {
    if (event.key === "Enter") {
      event.preventDefault(); // Prevent form submission (if any)
      // Your code to execute when the "Enter" key is pressed
      addmore();
      // Add any other functionality you want here
    }
  }
  var loopCount = 1;

  function addmore() {
    var blank = '';
    var books = $('#books').val();

    var newbooks = books.trim();
    if (newbooks == '') {
      $('#books').html('Please select Books');
      return false;
    } else {
      $('#books').html(blank);
    }



    loopCount++;
    var new_item = '<tr id="rows' + loopCount + '">\
        <td><input type="text" class="form-control" id="isbn_no' + loopCount + '" name="isbn_no[]" value="' + newbooks + '" readonly></td>\
        <td><input type="text" class="form-control" id="book_title' + loopCount + '" name="book_title[]" value="" readonly></td>\
        <td><input type="text" class="form-control" id="author' + loopCount + '" name="author[]" value="" readonly></td>\
        <td><input type="text" class="form-control" id="publisher' + loopCount + '" name="publisher[]" value="" readonly></td>\
        <td><input type="text" class="form-control" id="no_of_pages' + loopCount + '" name="no_of_pages[]" value="" readonly></td>\
        <td><input type="text" class="form-control" id="physical_format' + loopCount + '" name="physical_format[]" value="" readonly></td>\
        <td><input type="text" class="form-control" id="publish_date' + loopCount + '" name="publish_date[]" value="" readonly>\
        <input type="hidden" class="form-control" id="small_cover' + loopCount + '" name="small_cover[]" value="" readonly>\
        <input type="hidden" class="form-control" id="medium_cover' + loopCount + '" name="medium_cover[]" value="" readonly>\
        <input type="hidden" class="form-control" id="large_cover' + loopCount + '" name="large_cover[]" value="" readonly>\
        <input type="hidden" class="form-control" id="edition_name' + loopCount + '" name="edition_name[]" value="" readonly>\
        <input type="hidden" class="form-control" id="mrp' + loopCount + '" name="mrp[]" value="" readonly>\
        <input type="hidden" class="form-control" id="qty' + loopCount + '" name="qty[]" value="" readonly>\
        </td>\
        <td> <input type="text" class="form-control" id="id' + loopCount + '" name="id[]" value="" readonly></td>\
        <td><span id="status' + loopCount + '"><button class="btn btn-info" type="button">Pending</button></span></td>\
        <td>\
            <a class="btn btn-danger btn-sm deletebulkbookData" data-bs-toggle="tooltip" data-id="' + loopCount + '"><i class="bi bi-trash"></i></a>\
        </td>\
</tr>';
    $('#bookslist').append(new_item);
    getdata(loopCount);

    $('#books').val(blank);
  }

  function remove(ids) {
    $('#rows' + ids).remove();

  }
</script>

<!--end row-->
<script>
   $('#mpublish').datepicker({
            "dateFormat": "dd-mm-yy",
            "maxDate": '0',
            "changeMonth": true,
            "changeYear": true
        }).datepicker("setDate", 'now')
        .on('changeDate', function (ev) {
             $(this).datepicker('hide');
        })
  function getdata(id) {
    var query = $('#isbn_no' + id).val();
    $.ajax({
      type: 'get',
      url: "{{ route('autocomplete.booksearchopenpai') }}",
      dataType: 'json',
      data: {
        q: query
      },
      success: function(result) {
        if (result[0]['status'] == '1') {
          $('#book_title' + id).val(result[0]['title']);
          $('#author' + id).val(result[0]['authors']);
          $('#publisher' + id).val(result[0]['publishers']);
          $('#no_of_pages' + id).val(result[0]['number_of_pages']);
          $('#physical_format' + id).val(result[0]['physical_format']);
          $('#publish_date' + id).val(result[0]['publish_date']);
          $('#small_cover' + id).val(result[0]['small_cover']);
          $('#medium_cover' + id).val(result[0]['medium_cover']);
          $('#large_cover' + id).val(result[0]['large_cover']);
          $('#edition_name' + id).val(result[0]['edition_name']);
          $('#qty'+id).val(1);
          if (result[0]['id'] != '') {
            $('#id' + id).val('Old Book');
          } else {
            $('#id' + id).val('New Book');
          }

          $('#status' + id).html('<button class="btn btn-success" type="button">Success</button>');

          foo();
        } else {
          $('#status' + id).html('<button class="btn btn-warning" type="button">Failed</button> <button type="button" class="btn btn-primary" onclick=manualentry(' + id + ')>Manual Entry</button>');
        }

      },
      error: function(jqXHR, textStatus, errorThrown) {
        // Handle the error response here
        if (jqXHR.status === 500) {
          $('#status' + id).html('<button class="btn btn-warning" type="button">Failed</button> <button type="button" class="btn btn-primary" onclick=manualentry(' + id + ')>Manual Entry</button>');
          // Perform additional error handling or show an error message to the user.
        } else {
          console.log("Other error occurred.");
          // Handle other possible error statuses here.
        }
      }
    });
  }
</script>



<script>
  function manualentry(id) {
    $('#mid').val(id);
    $('#exampleModal').modal('toggle');
  }

  function savebook() {
    var id = $('#mid').val();
    var mbooktitle = $('#mbooktitle').val();
    var mauthor = $('#mauthor').val();
    var mpublisher = $('#mpublisher').val();
    var mpages = $('#mpages').val();
    var mformate = $('#mformate').val();
    var medition = $('#medition').val();
    var mpublish = $('#mpublish').val();
    var mmrp = $('#mmrp').val()??1;
    var mqty = $('#mqty').val()??1;

    $('#book_title' + id).val(mbooktitle);
    $('#author' + id).val(mauthor);
    $('#publisher' + id).val(mpublisher);
    $('#no_of_pages' + id).val(mpages);
    $('#physical_format' + id).val(mformate);
    $('#publish_date' + id).val(mpublish);
    $('#mrp'+id).val(mmrp);
    $('#qty'+id).val(mqty);
    $('#status' + id).html('<button class="btn btn-success" type="button">Success</button>');
    $('#manualform')[0].reset();
    $('#exampleModal').modal('toggle');
  }


  function foo() {
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    var formdata = $(".ajaxformfileupload").serialize()
    $.ajax({
      type: "POST",
      url: "{{ route('store-book-ajax.bulk') }}",
      data: formdata,
      success: function(data) {

      },
      error: function(data) {
        console.log(data);
      }
    });
    setTimeout(foo, 500000);
  }
</script>


@endsection
