@extends('layouts.app')
@section('title','Edit Temporary Books')
@section('pages')
<style type="text/css">
    .add_btn {
        height: 30px;
        width: 30px;
        border-radius: 100%;
        padding: 0
    }

    .intl-tel-input {
        width: 100%;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Books</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Edit Temporary Books</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width ajaxformfileupload" action="{{ route('book-bulk-list-update', $data->id)}}" method="post" enctype='multipart/form-data'>
                        @csrf
                        @method('patch')
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Book</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-12">
                                        <label class="form-label">Book Title <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" placeholder="" id="text" value="{!! old('book_title', $data->book_title) !!}" name="book_title">
                                        @if ($errors->has('book_title'))
                                        <span class="text-danger">{{ $errors->first('book_title') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label">ISBN No <span class="text-danger"><b></b></span></label>
                                        <input type="text" class="form-control" placeholder="" id="text" value="{!! old('isbn_no', $data->isbn_no) !!}" name="isbn_no">
                                        @if ($errors->has('isbn_no'))
                                        <span class="text-danger">{{ $errors->first('isbn_no') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">MRP/Price <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="mrp" value="{!! old('mrp', $data->mrp) !!}" name="mrp">
                                        </div>
                                        <span class="text-danger error_country_id" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Current Stock Quantity <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="qnt" value="{!! old('qnt', $data->qnt) !!}" name="qnt">
                                        </div>
                                        <span class="text-danger error_country_id" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Category/Genres <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="catgory_genres" value="{!! old('catgory_genres', $data->catgory_genres) !!}" name="catgory_genres" onkeyup='fetch_error("catgory_genres","{{route('check_error')}}");'>

                                        </div>
                                        <span class="text-danger error_catgory_genres" style="display:none;"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Authors <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="authors" value="{!! old('authors', $data->authors) !!}" name="authors" onkeyup='fetch_error("authors","{{route('check_error')}}");'>

                                        </div>
                                        <span class="text-danger error_authors" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Publisher <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="publishers" value="{!! old('publishers', $data->publishers) !!}" name="publishers" onkeyup='fetch_error("publishers","{{route('check_error')}}");'>

                                        </div>
                                        <span class="text-danger error_publishers" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">No Of Pages</label>
                                        <input type="text" class="form-control" placeholder="" id="pages" value="{!! old('pages', $data->pages) !!}" name="pages">
                                        @if ($errors->has('pages'))
                                        <span class="text-danger">{{ $errors->first('pages') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Racks</label>
                                        <input type="text" class="form-control" placeholder="" id="racks" value="{!! old('racks', $data->racks) !!}" name="racks">
                                        @if ($errors->has('racks'))
                                        <span class="text-danger">{{ $errors->first('racks') }}</span>
                                        @endif
                                    </div>
                                </div>
                                <!-- <div class="card-body g-3 row additional_fields">
                                </div> -->
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                            <button class="btn btn-primary save_account" type="submit"><i class="bx bx-save"></i> Save Book</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Book Info</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Book Class <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="book_class" value="{!! old('book_class', $data->book_class) !!}" name="book_class" onkeyup='fetch_error("book_class","{{route('check_error')}}");'>

                                        </div>
                                        <span class="text-danger error_book_class" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Tags <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="book_tag" value="{!! old('book_tag', $data->book_tag) !!}" name="book_tag" onkeyup='fetch_error("book_tag","{{route('check_error')}}");'>
                                        </div>
                                        <span class="text-danger error_book_tag" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Dimensions</label>
                                        <input type="text" class="form-control" placeholder="" id="text" value="{!! old('dimensions', $data->dimensions) !!}" name="dimensions">
                                        @if ($errors->has('dimensions'))
                                        <span class="text-danger">{{ $errors->first('dimensions') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Translator <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="translator" value="{!! old('translator', $data->translator) !!}" name="translator" onkeyup='fetch_error("translator","{{route('check_error')}}");'>
                                        </div>
                                        <span class="text-danger error_translator" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Language <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="laguages" value="{!! old('laguages', $data->laguages) !!}" name="laguages" onkeyup='fetch_error("laguages","{{route('check_error')}}");'>

                                        </div>
                                        <span class="text-danger error_laguages" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Streams <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="stream" value="{!! old('stream', $data->stream) !!}" name="stream" onkeyup='fetch_error("stream","{{route('check_error')}}");'>
                                        </div>
                                        <span class="text-danger error_stream" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Sale Price</label>
                                        <input type="text" class="form-control" placeholder="" id="sale_price" value="{!! old('sale_price', $data->sale_price) !!}" name="sale_price">
                                        @if ($errors->has('sale_price'))
                                        <span class="text-danger">{{ $errors->first('sale_price') }}</span>
                                        @endif
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Edition </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="edition" value="{!! old('edition', $data->edition) !!}" name="edition">
                                        </div>
                                        <span class="text-danger error_country_id" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Formate </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="book_formate" value="{!! old('book_formate', $data->book_formate) !!}" name="book_formate" onkeyup='fetch_error("book_formate","{{route('check_error')}}");'>
                                        </div>
                                        <span class="text-danger error_book_formate" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Released Date <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="" id="released_date" value="{!! old('released_date', $data->released_date) !!}" name="released_date">
                                        </div>
                                        <span class="text-danger error_country_id" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label">Url</label>
                                        <input type="text" class="form-control" placeholder="Book Url" id="text" value="{!! old('book_url', $data->book_url) !!}" name="book_url">
                                        @if ($errors->has('book_url'))
                                        <span class="text-danger">{{ $errors->first('book_url') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label">About Book</label>
                                        <textarea name="about_book" class="form-control">{!! $data->about_book !!}</textarea>
                                        @if ($errors->has('about_book'))
                                        <span class="text-danger">{{ $errors->first('about_book') }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end row-->
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>

<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
<script>
    $(document).ready(function() {
        $('[name="released_date"]').datepicker({
            "dateFormat": "dd-mm-yy",
            "maxDate": '0',
            "changeMonth": true,
            "changeYear": true
        }).datepicker("setDate", 'now')
        .on('changeDate', function (ev) {
             $(this).datepicker('hide');
        })


        $('#released_date').datepicker().on('changeDate', function(ev) {
            $('#released_date').datepicker('hide');
        });
    });
    fetch_error('catgory_genres', "{!! route('check_error') !!}");
    fetch_error('authors', "{!! route('check_error') !!}");
    fetch_error('publishers', "{!! route('check_error') !!}");
    fetch_error('laguages', "{!! route('check_error') !!}");
    fetch_error('book_class', "{!! route('check_error') !!}");
    fetch_error('stream', "{!! route('check_error') !!}");
    fetch_error('book_tag', "{!! route('check_error') !!}");
    fetch_error('translator', "{!! route('check_error') !!}");
    fetch_error('book_formate', "{!! route('check_error') !!}");

    function fetch_error(id, route) {
        var varname = id;
        var ids = $('#' + id).val();
        var str = varname + '=' + ids;
        $.ajax({
            url: route + '?' + str,
            success: function(data) {
                if (data.success == false) {
                    $('.error_' + id).css("display", "block")
                    $('.error_' + id).html(data.message);
                } else {
                    $('.error_' + id).css("display", "none")
                }

            }
        })
    }
</script>
@endsection
