<div class="card style_table shadow-none" style="margin-bottom:0.8rem;">
    <form class="g-3 ajaxformfileupload" action="{{route('bulktobook')}}" method="post" enctype='multipart/form-data'>
        <div class="card-header d-flex align-items-center justify-content-between">
            <h6 class="mb-0">Total Item in Cart <i class="bi bi-cart"></i> ({!! isset($bookTemData) ? count($bookTemData) : '0' !!})</h6>
            <button type="submit" class="btn btn-outline-primary" id="checkout"><i class="bx bx-plus"></i> Submit Temp To Final Book</button>
        </div>
        <div class="card-body pb-0">
            <div class="table-responsive">
                <table class="table table-bordered align-middle" style="width:100%">
                    <thead class="table-light">
                        <tr>
                            <th class="thbutton"><input type="checkbox" class="checkbox" id="selectAll"> All</th>
                            </th>
                            <th>ISBN NO</th>
                            <th>Book Title</th>
                            <th>Publisher</th>
                            <th>No of Pages</th>
                            <th>Quantity</th>
                            <th>Messages</th>
                            <th class="thbutton">Status</th>
                            <th class="thbutton">Edit</th>
                            <th class="thbutton">Delete</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $i=1;@endphp
                        @if(count($bookTemData)>0)
                        @foreach($bookTemData as $key=>$list)
                        <tr>
                            <td class="thbutton"><input type="checkbox" class="checkbox" name="bulk_id[]" value="{{$list->id}}"></td>
                            <td>{{$list->isbn_no}}</td>
                            <td>@if(isset($list->book_title))
                                @php echo wordwrap($list->book_title,30,"<br>\n") @endphp@endif<br>
                                <i class="bi bi-pencil-square text-info"></i> {{$list->authors}} <br>
                                @if(isset($list->book_formate))
                                ({{$list->book_formate??''}})
                                @endif
                            </td>

                            <td>{{$list->publishers??''}}</td>
                            <td>{{$list->pages??''}}</td>
                            <td width="10px"><input class="form-control" name="qnt[]" value="{{$list->qnt??1}}"></td>
                            <td>@if(trim($list->message))
                                 @php echo wordwrap($list->message,32,"<br>\n") @endphp
                                 @endif
                            </td>
                            <td>@if($list->status==0)
                                <span class="text-danger">Error</span>
                                @elseif($list->status==1)
                                <span class="text-info">Pending</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{route('book-bulk-list-edit',$list->id)}}" class="btn btn-outline-secondary edit" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                    <i class="bi bi-pencil-square"></i>
                                </a>
                            </td>
                            <td>
                                <a data-url="{{route('library.books.temp.destroy')}}" data-mainid="{{$list->id}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" data-bs-toggle="tooltip" data-bs-placement="bottom" aria-label="Delete">
                                    <i class="bi bi-trash text-white"></i>
                                </a>
                            </td>
                        </tr>
                        @php $i++; @endphp
                        @endforeach
                        @else
                        <tr>
                            <td colspan="9">No Data Found</td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            <nav class="row align-items-center mt-3">
                <div class="col-md-6">
                    {!! $bookTemData->onEachSide(1)->render('library.open-api.pagination') !!}
                </div>
            </nav>
        </div>
    </form>
</div>