@extends('layouts.app')
@section('title','Opening Stock Import')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
        border-right: none;
    }

    .card {
        margin-bottom: 0rem;
    }

    .form-control {
        height: 33px !important;
    }
</style>

<!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6"> Opening Stock Import </div>
    <div class="col-md-6">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb justify-content-md-end mb-0">
                <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="75" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                <li class="breadcrumb-item" aria-current="page">Opening Stock</li>
                <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Opening Stock</li>
                <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Upload Excel</li>
            </ol>
        </nav>
    </div>
</div>
<!--end breadcrumb-->

<!-- main -->
<div class="card style_table shadow-none radius-5 min-height">

    <div class="card-header py-3">

        @include('layouts.partials.nav-menu')

        <div class="row gx-2">

            <div class="col-lg-12 col-md-12">
                <div class="ms-auto float-md-end">

                    <div class="btn-group">
                        <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                    </div>

                   
                    <div class="btn-group">
                        <a href="{{route('export.book-stock-list')}}" class="btn btn-success"><i class="bi bi-download"></i> Download Excel Format</a>
                    </div>
                   
                </div>
            </div>
        </div>

    </div>

    <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
    <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
    <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
</div>
<!-- end main -->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width form ajaxformfileupload" action="{{route('import.book-stock-list')}}" enctype="multipart/form-data" method="POST">
                        @csrf
                        @method('post')
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Upload Opening Stock From Excel</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-3"></div>
                                    <div class="col-md-6">
                                        <label for="users">Upload Excel File
                                            <span class="text-danger"><b>*</b></span>
                                        </label>

                                        <input type="file" class="form-control import_author" name="book_stock" />
                                    </div>
                                    <span class="text-danger error_import_author" style="display:none;">This field is required.</span>
                                    <div class="col-md-3"></div>
                                    <div class="col-md-3"></div>

                                    <div class="col-6 d-flex justify-content-center mb-3">
                                        <button type="submit" style="width: 50%;" class="btn btn-secondary import_button">
                                            <i class="bi bi-upload "></i> Upload Opening Stock
                                        </button>
                                    </div>
                                    <div class="col-md-3"></div>
                                    <div class="col-md-3"></div>
                                    <div class="col-6 justify-content-center mb-3">
                                        <div style="" class="accordion-item">
                                            <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                                                    Guidelines For Opening Stock Upload:
                                                </button>
                                            </h2>
                                            <div style="" id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingTwo">
                                                <div class="accordion-body">
                                                    <strong>Note:</strong><br>
                                                    <p>Duplicate records will not be saved.<br>If a record already exists, only that record will be skipped.</p>
                                                    <strong>1. Book Name (required):</strong><br>
                                                    <p>Enter the Stock (mandatory, unique).</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection