@extends('layouts.app')
@section('title','Library')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
  <div class="breadcrumb-title pe-3">Library Management</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">
        <li class="breadcrumb-item"><a href="{{ url('dashboard')}}"><i class="bx bx-home-alt"></i></a></li>
        <li class="breadcrumb-item active" aria-current="page">Opening Stock</li>
      </ol>
    </nav>
  </div>
  <div class="ms-auto">
    <div class="btn-group">
      <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
    </div>
  </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width ajaxformfileupload" action="{{route('import.book-stock-list')}}"  method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @csrf
            <div class="col-md-8 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <div class="col-md-4 col-sm-12">
                      <h5 class="mb-0">Book Opening Stock</h5>
                    </div>
                    <div class="col-md-8 col-sm-12 ">
                      <a href="{{route('export.book-stock-list')}}" class="btn btn-info float-end float-lg-end"><i class="bi bi-arrow-down-circle"></i>  Download Book Opening Stock Sample</a>
                    </div>
                    <hr class="mb-0">
                  <div class="col-md-12 col-sm-12">
                    <div class="row g-3">
                      <div class="col-md-12 col-sm-12">
                        <label>Select CSV File <span class="text-danger">*</span></label>
                        <input type="file" class="form-control" name="book_stock">
                      </div>
                    </div>
                  </div>						
                  <div class="col-12" align="center">
                    <div class="d-grid gap-2 top-0 start-50">
                      <button class="btn btn-primary" type="submit"><i class="bx bx-save"></i> Save Opening Stock Details</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>

</div>
</div>
<!--end row-->
@endsection