@extends('layouts.app')
@section('title','Add Licence Details')
@section('pages')
<style type="text/css">
    .date {
        float: right;
        color: #212121;
    }

    .select2-selection__rendered {
        padding: 4px !important;
        padding-left: 8px !important;
    }

    .registration_date[readonly] , .first_activation[readonly] , .billing_start_date[readonly]  {
        border-color    : #ced4da !important;
        background-color: #ffffff !important;
        cursor          : pointer;
    }

    .add_btn {
        height: 30px; width: 30px; border-radius: 100%; padding: 0
    }
</style>
<link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Licence Details</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Add Licence Details</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            <!-- <a href="javascript:;" class="btn btn-primary"><i class="bx bx-file ms-0 me-1"></i>Save Course</a> -->
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" method="post" enctype='multipart/form-data' id="store-form">
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                            @csrf
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body g-3 row">
                                        <h5 class="mb-0">Basic Information</h5>
                                        <hr class="mb-0">
                                        <div class="col-md-12">
                                            <div>
                                                <label for="category_id" class="form-label">Plan And Packages <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="form-control" name="plan_and_packages_id" required>
                                                    @foreach ($planAndPackages as $key => $list)
                                                        <option value="{!! $list->id !!}">{!! $list->plan_name !!}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_plan_and_packages" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div>
                                                <label for="category_id" class="form-label">Biling Interval <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="form-control" name="billing_interval_id" required>
                                                    <option value="">Select Biling Interval </option>
                                                    @foreach($biling_intervals as $list)
                                                    <option value="{{ $list->id }}">{{ $list->biling_interval }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_billing_interval" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                                <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Quantity <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="validationCustomTitle" name="quantity" aria-describedby="inputGroupPrepend" required value="1">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Selling Price <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="validationCustomTitle" name="taxable_rate" aria-describedby="inputGroupPrepend" required value="0">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Discount Type </span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="form-control" name="discount_type" required>
                                                    <option value="">Select Discount Type </option>
                                                        <option value="flat">Flat</option>
                                                        <option value="percentage">Percentage</option>
                                                </select>
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Discount value </label>
                                            </div>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="validationCustomTitle" name="discount_value" aria-describedby="inputGroupPrepend" required value="0">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">1st activation <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="text" class="form-control first_activation" readonly id="validationCustomTitle" name="first_activation" value="{!! date('d-m-Y') !!}" aria-describedby="inputGroupPrepend" required>
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Billing Start Date <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="text" class="form-control billing_start_date" value="{!! date('d-m-Y') !!}" readonly id="validationCustomTitle" name="billing_start_date" aria-describedby="inputGroupPrepend" required>
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-12">
                                            <br>
                                            <div class="d-grid gap-2 with-100">
                                                <button type="button" class="btn btn-primary save_course">Save Licence Details</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body g-3 row">
                                        <h5 class="mb-0">Additional Info</h5>
                                        <hr class="mb-0">
                                        <div class="col-md-12">
                                            <div>
                                                <label for="category_id" class="form-label">Server <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="form-control" name="server_id" required>
                                                    <option value="">Select Server </option>
                                                    @foreach ($servers as $key => $list)
                                                        <option value="{!! $list->id !!}">{!! $list->server_name !!}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_server" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                                <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div>
                                                <label for="course_title" class="form-label">Frontend URL </label>
                                            </div>
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="validationCustomTitle" name="front_end_url" aria-describedby="inputGroupPrepend" required>
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-12">
                                            <div>
                                                <label for="course_title" class="form-label">Backend URL </label>
                                            </div>
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="validationCustomTitle" name="back_end_url" aria-describedby="inputGroupPrepend" required>
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="category_id" class="form-label">Type <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="form-control" name="type" required>
                                                    <option value="Add-on" {!! ($previous) ? 'selected' : '' !!}>Add-on</option>
                                                    <option value="Main" {!! (!$previous) ? 'selected' : '' !!}>Main</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Production <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select  class="form-control" name="production">
                                                    <option value="">Select</option>
                                                    <option value="demo">Demo</option>
                                                    <option value="live">Live</option>
                                                </select>
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Registration Date <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="text" class="form-control registration_date" readonly id="validationCustomTitle" value="{!! date('d-m-Y') !!}" name="registration_date"  aria-describedby="inputGroupPrepend" required>
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>

                                        @if($id)
                                            <input type="hidden" name="order_id" value="{!! $id !!}">
                                        @else
                                            <div class="col-md-6">
                                                <div>
                                                    <label for="category_id" class="form-label">License Order <span class="text-danger"><b>*</b></span></label>
                                                </div>
                                                <div class="input-group">
                                                    <select class="form-control" name="order_id" required>
                                                        <option value="">Select Order </option>
                                                        @foreach ($licence as $key => $list)
                                                            <option value="{!! $list->id !!}">{!! $list->license_no !!}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                            </div>
                                        @endif

                                        <div class="col-md-6">
                                            <label for="validationCustomOrder" class="form-label mt-4"><strong>Maintenance Mode </strong></label>
                                            <input name="maintenance_mode" class="form-check-inputFeatured btn-lg" type="checkbox" id="inlineCheckboxFeatured">
                                            <span class="text-danger error_name" style="display: none;">This field is required.</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                      </form>
                  </div>
              </div>
          </div>
      </div>
  </div>
  <!--end row-->
@endsection

@section('js')
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
<script>
    $(document).ready(function() {

        $( function() {
            $('.registration_date').datepicker({
            dateFormat: 'dd mm yy'
            })
            $('.first_activation').datepicker({
            dateFormat: 'dd mm yy'
            })
             $('.billing_start_date').datepicker({
                dateFormat: 'dd mm yy',

            });
        });

        $(document).on('click', '.save_course', function() {
            let saveButton = $('.save_course');
            let formdata = new FormData($('#store-form')[0]);

            $.ajax({
                url:"{!! route('license-details.store') !!}",
                data: formdata,
                processData: false,
                contentType: false,
                type: 'POST',
                success:function(response) {
                    saveButton.prop('disabled', true);
                    if (response.success == false) {
                        saveButton.prop('disabled', false);
                        toastr.error(response.message, 'Error!');
                    }

                    if (response.success == true) {

                        toastr.success(response.message, 'Success.');
                        setTimeout(function() {
                            @if($id)
                                location.href = "{!! route('license-registered-details', $id) !!}";
                            @else
                                location.href = "{!! route('license-details.index') !!}";
                            @endif
                        }, 2000);
                    }
                }
            }).fail(function(jqXHR, textStatus, errorThrown) {
                toastr.error('An error occurred during the request.', 'Error!');
            });
        });
    });

    $(document).on('click', '#create_billing_interval', function(){
        $('#commonModalLabel').text('Add New Biling intervals');
        $('.save_button_span').text('Save Biling intervals');
        $.ajax({
          url:"{!! route('biling-interval.create') !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
            $.switcher('.lifetime');
          }
        })
    });
    // create plan and packages
    $(document).on('click', '#create_plan_and_packages', function(){
        $('#commonModalLabel').text('Add New Plan And Packages');
        $('.save_button_span').text('Save Plan And Packages');
        $.ajax({
          url:"{!! route('plan-and-packages.create') !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
          }
        })
    });


    $(document).on('click', '#create_server', function(){
        $('#commonModalLabel').text('Add New Server');
        $('.save_button_span').text('Save Server');
        $.ajax({
          url:"{!! route('server.create') !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
            $.switcher('.lifetime');
          }
        })
    });

    $(document).on('click', '.save_button', function(event) {
        event.preventDefault();
        $('.error_biling_interval').hide();
        var error = 0;

        if ($('#commonModal').find('form').hasClass('bilingInterval')) {
            if ($('#commonModal').find('form').find('[name="biling_interval"]').val() == '') {
                $('.error_biling_interval').show();
                error = 1;
            }

            if (error == 0) {
                let formdata = new FormData($('#commonModal').find('form')[0]);

                $.ajax({

                    url: $('#commonModal').find('form').attr('action'),
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function(response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');

                            // append new biling_interval to selection
                            $('[name="biling_interval"]').append(`<option value="${response.data.id}" selected>${response.data.biling_interval}</option>`);
                            $('[name="biling_interval"]').trigger('change');


                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');

                    // hide modal
                    $('#commonModal').modal('hide');
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').removeClass('category');
                });
            }
            error = 1;
        }

        else if ($('#commonModal').find('form').hasClass('server')) {
            $('.error_server_name').hide();

            if ($('#commonModal').find('form').find('input[name="server_name"]')
                .val().trim() == '') {
              $('.error_server_name').show();
              error = 1;
            }

            if (error == 0) {
                let formdata = new FormData($('#commonModal').find('form')[0]);

                $.ajax({
                    url: "{!! route('server.store') !!}",
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function (response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');
                            // append new category to selection
                            $('[name="server_id"]').append(`<option value="${response.data.id}" selected>${response.data.server_name}</option>`);
                            $('[name="server_id"]').trigger('change');

                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');

                    // hide modal
                    $('#commonModal').modal('hide');
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').removeClass('category');
                });
            }

        }
        else if ($('#commonModal').find('form').hasClass('planAndPackages')) {
            console.log('test');
            if ($('#commonModal').find('form').find('[name="plan_name"]').val() == '') {
                $('.error_plan_name').show();
                error = 1;
            }

            if (error == 0) {
                let formdata = new FormData($('#commonModal').find('form')[0]);

                $.ajax({

                    url: $('#commonModal').find('form').attr('action'),
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function(response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');

                            // append new planAndPackages to selection
                            $('[name="plan_and_packages_id"]').append(`<option value="${response.data.id}" selected>${response.data.plan_name}</option>`);
                            $('[name="plan_and_packages_id"]').trigger('change');


                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');

                    // hide modal
                    $('#commonModal').modal('hide');
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').removeClass('planAndPackages');
                });
            }
            error = 1;
        }

    })
</script>
@endsection
