@extends('layouts.app')
@section('title','Update Licence Details')
@section('pages')
<style type="text/css">
    .registration_date[readonly] , .first_activation[readonly] , .billing_start_date[readonly]  {
        border-color: #ced4da !important;
        background-color: #ffffff !important;
        cursor: pointer;
    }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Licence Details</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Update Licence Details</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            <!-- <a href="javascript:;" class="btn btn-primary"><i class="bx bx-file ms-0 me-1"></i>Save Course</a> -->
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" method="post" enctype='multipart/form-data' id="store-form">
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                            @csrf
                            @method('patch')
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body g-3 row">
                                        <h5 class="mb-0">Basic Information</h5>
                                        <hr class="mb-0">
                                        <div class="col-md-12">
                                            <div>
                                                <label for="plan_and_packages_id" class="form-label">Plan And Packages <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="form-control" name="plan_and_packages_id" required>
                                                    @foreach ($planAndPackages as $key => $list)
                                                    <option value="{{ $list->id }}" {{ $list->id == $data->plan_and_packages_id ? 'selected':'' }}>{{ $list->plan_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div>
                                                <label for="category_id" class="form-label">Biling Interval <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select" name="billing_interval_id" required>
                                                    <option value="">Select Biling Interval </option>
                                                    @foreach ($biling_intervals as $key => $list)
                                                        {{-- <option value="{!! $biling->id !!}" {!! matchSelected($data->billing_interval_id, $biling->id) !!}>{!! $biling->biling_interval !!}</option> --}}
                                                        <option value="{{ $list->id }}" {{ $list->id == $data->billing_interval_id ? 'selected':'' }}>{{ $list->biling_interval }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Quantity <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="validationCustomTitle" name="quantity" aria-describedby="inputGroupPrepend" required  value="{!! $data->quantity ?? '' !!}">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Selling Price <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="validationCustomTitle" name="taxable_rate" aria-describedby="inputGroupPrepend" required value="{!! $data->taxable_rate ?? '' !!}">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Discount Type </label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select" name="discount_type" required>
                                                    <option value="">Select Discount Type </option>
                                                        <option value="flat" {!! matchSelected($data->discount_type, 'flat') !!}>Flat</option>
                                                        <option value="percentage" {!! matchSelected($data->discount_type, 'percentage') !!}>Percentage</option>
                                                </select>
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Discount value </label>
                                            </div>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="validationCustomTitle" name="discount_value" aria-describedby="inputGroupPrepend" required value="{!! $data->discount_value ?? '' !!}">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Registration Date <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="" readonly class="form-control registration_date" id="validationCustomTitle" name="registration_date" aria-describedby="inputGroupPrepend" required value="{!! $data->registration_date != '' && $data->registration_date != '0000-00-00' ? date('m/d/Y', strtotime($data->registration_date)) : '' !!}">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">1st activation <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="text" readonly class="form-control first_activation" id="validationCustomTitle" name="first_activation" aria-describedby="inputGroupPrepend" required value="{!! $data->first_activation != '' && $data->first_activation != '0000-00-00' ? date('m/d/Y', strtotime($data->first_activation)) : '' !!}">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        
                                        <div class="col-md-12">
                                            <br>
                                            <div class="d-grid gap-2 with-100">
                                                <button type="button" class="btn btn-primary save_course">Save Licence Details</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body g-3 row">
                                        <h5 class="mb-0">Additional Info</h5>
                                        <hr class="mb-0">
                                        <div class="col-md-12">
                                            <div>
                                                <label for="category_id" class="form-label">Server <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select" name="server_id" required>
                                                    <option value="">Select Server </option>
                                                    @foreach ($servers as $key => $list)
                                                        <option value="{!! $list->id !!}" {!! matchSelected($data->server_id,$list->id) !!}>{!! $list->server_name !!}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div>
                                                <label for="course_title" class="form-label">Frontend URL </label>
                                            </div>
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="validationCustomTitle" name="front_end_url" aria-describedby="inputGroupPrepend" required value="{!! $data->front_end_url ?? '' !!}">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-12">
                                            <div>
                                                <label for="course_title" class="form-label">Backend URL </label>
                                            </div>
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="validationCustomTitle" name="back_end_url" aria-describedby="inputGroupPrepend" required value="{!! $data->back_end_url ?? '' !!}">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="category_id" class="form-label">Type <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select" name="type" required>
                                                    <option value="Add-on" {!! $data->type == 'Add-on' ? 'selected' : '' !!}>Add-on</option>
                                                    <option value="Main" {!! $data->type == 'Main' ? 'selected' : '' !!}>Main</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Production <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="form-select"  name="production">
                                                    <option value="demo" {{ matchSelected($data->production,'demo') }}>Demo</option>
                                                    <option value="live" {{ matchSelected($data->production,'live') }}>Live</option>
                                                </select>
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="category_id" class="form-label">License Order <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select" name="order_id" required>
                                                    <option value="">Select Order </option>
                                                    @foreach ($licence_list as $key => $list)
                                                        <option value="{!! $list->id !!}" {!! matchSelected($data->order_id,$list->id)  !!}>{!! $list->license_no !!}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_title" class="form-label">Billing Start Date <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="text" readonly class="form-control billing_start_date" id="validationCustomTitle" name="billing_start_date" aria-describedby="inputGroupPrepend" required value="{!! $data->billing_start_date != '' && $data->billing_start_date != '0000-00-00' ? date('m/d/Y', strtotime($data->billing_start_date)) : '' !!}">
                                            </div>
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                         <div class="col-md-6">
                                            <label for="validationCustomOrder" class="form-label"><strong>Maintenance Mode </strong></label>
                                            <input name="maintenance_mode" class="form-check-inputFeatured btn-lg" type="checkbox" id="inlineCheckboxFeatured" {{ $data->maintenance_mode == '1' ? 'checked' : ''}}>
                                            <span class="text-danger error_name" style="display: none;">This field is required.</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                      </form>
                  </div>
              </div>
          </div>
      </div>
  </div>
  <!--end row-->
@endsection

@section('js')
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
<script>
    $(document).ready(function() {
        $( function() {
            $('.registration_date').datepicker();
            $('.first_activation').datepicker();
            $('.billing_start_date').datepicker();
        });
        $(document).on('click', '.save_course', function() {
            let formdata = new FormData($('#store-form')[0]);

            $.ajax({
                url:"{!! route('license-details.update', $id) !!}",
                data: formdata,
                processData: false,
                contentType: false,
                type: 'POST',
                success:function(response) {
                    if (response.success == false) {
                        toastr.error(response.message, 'Error!');
                    }

                    if (response.success == true) {
                        toastr.success(response.message, 'Success.');
                        setTimeout(function() {
                            location.href = "{!! route('license-details.index') !!}";
                        }, 2000);
                    }
                }
            }).fail(function(jqXHR, textStatus, errorThrown) {
                toastr.error('An error occurred during the request.', 'Error!');
            });
        });

        $('#search_product').autocomplete({
            autoFocus: true,
            minLength: 0,
            source: function(request, response) {
                if (request.term.length < 2) {
                    $('[name="search_product"]').val('');
                    $('[name="product_id"]').val('');
                    $('[name="product_price_id"]').val('');
                    return false;
                }

                var brand_id = $('#brand_id option:selected').val();

                $.ajax({
                    url: '{{ route('billings-search-product') }}',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        brand_id: brand_id,
                        search: request.term,
                    },
                    success: function(json) {
                        if (json.error) {
                            $('.add_to_cart').attr('id', '');
                            $('.add_to_cart').data('id', '');
                            return false;
                        }
                        response($.map(json.result, function(item) {
                            return {
                                id       : item.id,
                                price_id : item.price_id,
                                name     : item.name,
                                code     : item.shortcode,
                                short    : item.hsncode,
                                mrp      : item.mrp
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {
                $('#search_product').val(ui.item.name);
                $('[name="product_id"]').val(ui.item.id);
                $('[name="product_price_id"]').val(ui.item.price_id);

                return false;
            }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            return $("<li>")
                .addClass("custom-ui-li")
                .append("<a>" + item.name + " | Price:" + item.mrp + "</a>")
                .appendTo(ul);
        };
    });
</script>
@endsection
