 <div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Order Date</th>
                <th>Server links</th>
                <th>Client links</th>
                <th>License No</th>
                <th>Dates</th>
                <th>Billing Interval</th>
                <th width="10%">Maintenance</th>
                <th width="10%">Status</th>
                @if(in_array('license-details-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('license-details-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>{!! isset($list->license_registered->order_date) ? formatedDate($list->license_registered->order_date):'' !!}</td>
                        <td>
                            @if ($list->server->server_name != '')
                            <strong>{!! $list->server->server_name !!}</strong> <br />
                            @endif
                            @if ($list->server->login_link != '')
                            <a href="{!! $list->server->login_link !!}" target="_blank">Login Link</a>
                            @endif
                        </td>
                        <td>
                            @if ($list->front_end_url != '')
                            <a href="{!! strpos($list->front_end_url, 'http://') === 0 || strpos($list->front_end_url, 'https://') === 0 ? $list->front_end_url : 'http://' . $list->front_end_url !!}" target="_blank">Frontend Link</a><br />
                            @endif
                            @if ($list->back_end_url != '')
                            <a href="{!! strpos($list->back_end_url, 'http://') === 0 || strpos($list->back_end_url, 'https://') === 0 ? $list->back_end_url : 'http://' . $list->back_end_url !!}" target="_blank">Backend Link</a>
                            @endif
                        </td>
                        <td>
                            <a href="{!! route('license-activation-history',$list->id) !!}">{!! $list->license_registered->license_no ?? '' !!}</a>
                        </td>
                        <td>
                            <p>
                                <strong>Registration: </strong>{!! formatedDate($list->registration_date) !!}<br />
                                <strong>1st Activation: </strong>{!! formatedDate($list->first_activation) !!}<br />
                                <strong>Billing Start: </strong>{!! formatedDate($list->billing_start_date) !!}
                            </p>
                        </td>
                        <td>
                            <strong>{!! $list->billing_interval->biling_interval ?? '' !!}</strong><br />
                            Quantity: {!! $list->quantity !!} <br />
                            Selling Price: {!! $list->taxable_rate !!} <br />
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('license-details.changeMaintenanceMode')}}" data-id="{{$list->id}}" data-status="{{$list->maintenance_mode=='0' ? '1' : '0'}}" {{ $list->maintenance_mode=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('license-details.changeStatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('license-details-edit', $authRolePermissions))
                        <td class="text-center">
                            <a class="btn btn-warning edit" href="{!! route('license-details.edit', $list->id) !!}"><i class="bi bi-pencil-square text-white"></i></a>
                        </td>
                        @endif
                        @if(in_array('license-details-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('license-details.destroy', $list->id)}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="13">No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="float-start mt-2">
    <ul class="pagination">
        {!! $data->onEachSide(0)->render('license-details.pagination') !!}
    </ul>
</nav>
</div>

