@extends('layouts.app')
@section('pages')

    <div class="card style_table shadow-none radius-5 min-height">
        <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
        </div>
    </div>

    @if (in_array('Admin', $roleNames))
    <div class="row row-cols-1 row-cols-lg-4 row-cols-xl-4 row-cols-xxl-4">
        <div class="col-12">
            <h6>License Summary</h6>
        </div>
        <div class="col" onclick='window.location = "{!! route('license.report', 'clients') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Client</p>
                            <h4 class="mb-0 text-primary">{!! $totalClients !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-people"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col" onclick='window.location = "{!! route ('license-register.index') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">License</p>
                            <h4 class="mb-0 text-primary">{!! $totalLicense !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-card-text"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col" onclick='window.location = "{!! route('service.report', 'main') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Main Services</p>
                            <h4 class="mb-0 text-primary">{!! $totalMainServices !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-kanban-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col" onclick='window.location = "{!! route('service.report', 'add-on') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Add-on</p>
                            <h4 class="mb-0 text-primary">{!! $totalAddon !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-kanban-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
    </div>
    @endif

    <div class="row row-cols-1 row-cols-lg-4 row-cols-xl-4 row-cols-xxl-4">
        <div class="col-12">
            <h6>Renewal Summary</h6>
        </div>
        <div class="col" onclick='window.location = "{!! route('renewal.report', 'week') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">This Week</p>
                            <h4 class="mb-0 text-primary">{!! $recordsThisWeek !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-calendar2-x-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col" onclick='window.location = "{!! route('renewal.report', 'month') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">This Month</p>
                            <h4 class="mb-0 text-primary">{!! $recordsThisMonth !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-calendar2-x-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col" onclick='window.location = "{!! route('renewal.report', 'quarter') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">This Quarter</p>
                            <h4 class="mb-0 text-primary">{!! $recordsThisQuarter !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-calendar2-x-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col" onclick='window.location = "{!! route('renewal.report', 'half-yearly') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">This Half Yearly</p>
                            <h4 class="mb-0 text-primary">{!! $recordsThisHalfYear !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-calendar2-x-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
    </div>

    @if (in_array('Admin', $roleNames))
    <div class="row row-cols-1 row-cols-lg-4 row-cols-xl-4 row-cols-xxl-4">
        <div class="col-12">
            <h6>Revenue Summary</h6>
        </div>
        <div class="col" onclick='window.location = "{!! route('revenue.report', 'monthly') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Monthly Revenue</p>
                            <h4 class="mb-0 text-primary">{!! $monthlyRevenue->revenue !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-currency-rupee"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col" onclick='window.location = "{!! route('revenue.report', 'quarterly') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Quarterly Revenue</p>
                            <h4 class="mb-0 text-primary">{!! $quarterlyRevenue->revenue !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-currency-rupee"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col" onclick='window.location = "{!! route('revenue.report', 'half-yearly') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Half Yearly Revenue</p>
                            <h4 class="mb-0 text-primary">{!! $halfYearlyRevenue->revenue !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-currency-rupee"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col" onclick='window.location = "{!! route('revenue.report', 'yearly') !!}"' style="cursor: pointer;">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Yearly Revenue</p>
                            <h4 class="mb-0 text-primary">{!! $yearlyRevenue !!}</h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-currency-rupee"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
    </div>
    @endif

@endsection
