@extends('layouts.app')
@section('title','License')
@section('pages')
<style type="text/css">
    .add_btn {
        height: 30px; width: 30px; border-radius: 100%; padding: 0
    }
    .intl-tel-input {
        width: 100%;
    }
    .account_title {
        width: 50px;
        border: 1px solid #ced4da;
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }
</style>
<link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> License</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Add New License</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('license-register.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    {{ \Request::get('redirect_back') }}
                    <form class="row g-3 auto-width" action="{!! route('license-register.update', $data->id) !!}" method="post" enctype='multipart/form-data' id="account_form">
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                        @csrf
                        @method('PUT')
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">License Details</h5>
                                    <hr class="mb-0">
                                    <!-- <div class="col-md-12">
                                        <div>
                                            <label for="license_no" class="form-label">License No <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="license_no" class="form-control" value="{!! old('license_no', $data->license_no) !!}" placeholder="License No">
                                        </div>
                                        @if ($errors->has('license_no'))
                                            <span class="text-danger">{{ $errors->first('license_no') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div> -->
                                    <div class="col-md-6">
                                        <div>
                                            <label for="license_date" class="form-label">License Date <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="license_date" class="form-control" value="{!! formatedDate(old('license_date', $data->license_date)) !!}" placeholder="License Date">
                                        </div>
                                        @if ($errors->has('license_date'))
                                            <span class="text-danger">{{ $errors->first('license_date') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="order_date" class="form-label">Order Date <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="order_date" class="form-control" value="{!! formatedDate(old('order_date', $data->order_date)) !!}" placeholder="Order Date">
                                        </div>
                                        @if ($errors->has('order_date'))
                                            <span class="text-danger">{{ $errors->first('order_date') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label for="name" class="form-label">Bill To Account <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control" name="bill_to_account_id">
                                                @foreach($customers as $list)
                                                <option value="{{ $list->id }}" {!! $data->bill_to_account_id == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                                                @endforeach
                                            </select>
                                            <div class="input-group-append" style="margin: auto 10px;">
                                                <a href="{!! route('accounts.create', ['type' => 'customer', 'callback' => 'license']) !!}">
                                                    <button class="btn btn-success add_btn" type="button"> + </button>
                                                </a>
                                            </div>
                                        </div>
                                        @if ($errors->has('name'))
                                            <span class="text-danger">{{ $errors->first('name') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label for="project_id" class="form-label">Project <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control" name="project_id">
                                                @foreach($projects as $list)
                                                <option value="{{ $list->id }}" {!! $data->project_id == $list->id ? 'selected' : '' !!}>{{ $list->title . ' - ' . $list->code }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @if ($errors->has('project_id'))
                                            <span class="text-danger">{{ $errors->first('project_id') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label for="billing_company_id" class="form-label">Billing Company <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control" name="billing_company_id">
                                                @foreach($companies as $list)
                                                <option value="{{ $list->id }}" {!! $data->billing_company_id == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @if ($errors->has('billing_company_id'))
                                            <span class="text-danger">{{ $errors->first('billing_company_id') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label for="ship_to_account_id" class="form-label">Ship To Account <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control" name="ship_to_account_id">
                                                @foreach($customers as $list)
                                                <option value="{{ $list->id }}" {!! $data->ship_to_account_id == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                                                @endforeach
                                            </select>
                                            <div class="input-group-append" style="margin: auto 10px;">
                                                <a href="{!! route('accounts.create', ['type' => 'customer', 'callback' => 'license']) !!}">
                                                    <button class="btn btn-success add_btn" type="button"> + </button>
                                                </a>
                                            </div>
                                        </div>
                                        @if ($errors->has('ship_to_account_id'))
                                            <span class="text-danger">{{ $errors->first('ship_to_account_id') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                </div>
                                <div class="card-body g-3 row additional_fields">
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                          <button class="btn btn-primary save_account"  type="submit"><i class="bx bx-save"></i> Save Account Details</button>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Additional Information</h5>
                                    <hr class="mb-0">
                                    
                                    <div class="col-md-12">
                                        <div>
                                            <label for="partner_id" class="form-label">Partner </label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control" name="partner_id">
                                                <option value="">Select Partner</option>
                                                @foreach($partners as $list)
                                                <option value="{{ $list->id }}" {!! $data->partner_id == $list->id ? 'selected' : '' !!}>{{ $list->print_name }}</option>
                                                @endforeach
                                            </select>
                                            <div class="input-group-append" style="margin: auto 10px;">
                                                <a href="{!! route('accounts.create', ['type' => 'Referral Partner', 'callback' => 'license']) !!}">
                                                    <button class="btn btn-success add_btn" type="button"> + </button>
                                                </a>
                                            </div>
                                        </div>
                                        @if ($errors->has('partner_id'))
                                            <span class="text-danger">{{ $errors->first('partner_id') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label for="sales_person_id" class="form-label">Sales Person </label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control" name="sales_person_id">
                                                <option value="">Select Agent</option>
                                                @foreach($agents as $list)
                                                <option value="{{ $list->id }}" {!! $data->sales_person_id == $list->id ? 'selected' : '' !!}>{{ $list->print_name }}</option>
                                                @endforeach
                                            </select>
                                            <div class="input-group-append" style="margin: auto 10px;">
                                                <a href="{!! route('accounts.create', ['type' => 'Sales Agent', 'callback' => 'license']) !!}">
                                                    <button class="btn btn-success add_btn" type="button"> + </button>
                                                </a>
                                            </div>
                                        </div>
                                        @if ($errors->has('sales_person_id'))
                                            <span class="text-danger">{{ $errors->first('sales_person_id') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label for="account_manager_id" class="form-label">Manager </label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control" name="account_manager_id">
                                                <option value="">Select Manager</option>
                                                @foreach($managers as $list)
                                                <option value="{{ $list->id }}" {!! $data->account_manager_id == $list->id ? 'selected' : '' !!}>{{ $list->print_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @if ($errors->has('account_manager_id'))
                                            <span class="text-danger">{{ $errors->first('account_manager_id') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label for="license_note" class="form-label">License Note </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="license_note" class="form-control" value="{!! old('license_note', $data->license_note) !!}" placeholder="License Note">
                                        </div>
                                        @if ($errors->has('license_note'))
                                            <span class="text-danger">{{ $errors->first('license_note') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label for="client_remarks" class="form-label">Client Remarks </label>
                                        </div>
                                        <div class="input-group">
                                            <textarea name="client_remarks" class="form-control">{!! old('client_remarks', $data->client_remarks) !!}</textarea>
                                        </div>
                                        @if ($errors->has('client_remarks'))
                                            <span class="text-danger">{{ $errors->first('client_remarks') }}</span>
                                        @endif
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                  </form>
              </div>
          </div>
      </div>
  </div>
</div>
<!--end row-->
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
 @php $auth_format = \Session::get('company_data')['date_format'] ?? ''; @endphp
<script type="text/javascript">
    $( function() {
        $('[name="order_date"]').datepicker({
            format: "{!! phpToJsDateFormat($auth_format) !!}",
        }).on('changeDate', function (ev) {
             $(this).datepicker('hide');
        })
        $('[name="license_date"]').datepicker({
            format: "{!! phpToJsDateFormat($auth_format) !!}",
        }).on('changeDate', function (ev) {
             $(this).datepicker('hide');
        })
    });
</script>
@endsection
