<form class="row g-3 auto-width" action="{{ route('license-types.update', $type->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-12">
        <label for="validationCustom01" class="form-label">Country Name <span class="text-danger"><b>*</b></span></label>
        <select class="form-control single-select" name="country_id" class="form-control">
          <option value="">Select</option>
          @foreach($countries as $list)
            <option value="{{ $list->id }}" {{ $type->country_id == $list->id ? 'selected' : '' }}>{{ $list->name }}</option>
          @endforeach
        </select>
        <span class="text-danger error_country_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend" required value="{{$type->name}}">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="code" class="form-label">Code <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="code" name="code" aria-describedby="inputGroupPrepend" required value="{{$type->code}}">
        <span class="text-danger error_code" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" id="priority" name="priority" aria-describedby="inputGroupPrepend" required value="{{$type->priority}}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="data_length" class="form-label">Data Length <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="data_length" name="data_length" aria-describedby="inputGroupPrepend" required placeholder="Data Length" value="{{$type->data_length}}">
        <span class="text-danger error_data_length" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="value_type" class="form-label">Value Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-select" name="value_type">
            <option value="number" {!! matchSelected($type->value_type, 'number') !!}>Numbers</option>
            <option value="text" {!! matchSelected($type->value_type, 'text') !!}>Text</option>
            <option value="number_and_text" {!! matchSelected($type->value_type, 'number_and_text') !!}>Numbers and Text</option>
        </select>
        <span class="text-danger error_value_type" style="display:none;">This field is required.</span>
    </div>
</form>