@extends('layouts.app')
@section('title', 'Marketing')
@section('pages')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Marketing List</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Update Marketing</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('marketing.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->
<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('marketing.update', $market->id) }}" method="POST" enctype='multipart/form-data' id="marketing">
                        @csrf
                        @method('patch')
                        <!-- validated columns -->
                        <!-- <form class="row g-3 was-validated"> -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Marketing Details</h5>
                                    <hr class="mb-0">
                                     <!-- Name -->
                                     <div class="col-md-12">
                                        <label for="name" class="form-label">Name </label>
                                        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend" required placeholder="Name" value="{{$market->name}}">
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <!-- Business Name -->
                                    <div class="col-md-12">
                                        <label for="business_name" class="form-label">Business Name <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="business_name" name="business_name" aria-describedby="inputGroupPrepend" required placeholder="Business Name" value="{{$market->business_name}}">
                                        <span class="text-danger error_business_name" style="display:none;">This field is required.</span>
                                    </div>

                                    {{-- business_category_id --}}
                                    <div class="col-md-6">
                                        <div>
                                            <label for="business_category_id" class="form-label">Business Category <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control" name="business_category_id">
                                                <option value="">-- Select Business Category -- </option>
                                                @foreach ($business as $list)
                                                <option value="{{ $list->id }}" {{ $list->id == $market->business_category_id ? 'selected' : '' }}>
                                                    {{ $list->name }}
                                                @endforeach
                                            </select>
                                        </div>
                                        <span class="text-danger error_business_category_id" style="display: none;">This field is required.</span>
                                    </div>

                                     <!-- phone_number -->
                                     <div class="col-md-6 phone_number_col">
                                        <label for="phone_number" class="form-label">Phone Number <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control " id="phone_number"  aria-describedby="inputGroupPrepend" required placeholder="Phone Number" value="{{$market->phone_number}}">
                                        <input type="hidden" name="phone_number">
                                        <span class="text-danger error_phone_number" style="display:none;">This field is required.</span>
                                    </div>
                                    <!-- email -->
                                    <div class="col-md-12">
                                        <label for="email" class="form-label">Email <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="email" name="email" aria-describedby="inputGroupPrepend" required placeholder="Email"  value="{{$market->email}}">
                                        <span class="text-danger error_email" style="display:none;">This field is required.</span>
                                    </div>
                                       <!-- Address -->
                                       <div class="col-md-12">
                                        <label for="address" class="form-label">Address <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="address" name="address" aria-describedby="inputGroupPrepend" required placeholder="Address"  value="{{$market->address}}">
                                        <span class="text-danger error_address" style="display:none;">This field is required.</span>
                                    </div>
                                </div>
                                <div class="card-body g-3 row additional_fields">
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                            <button class="btn btn-primary save_marketing">Save Record</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Additional Information</h5>
                                    <hr class="mb-0">
                                    <!-- GBP Link -->
                                    <div class="col-md-12">
                                        <label for="gbp_link" class="form-label">GBP Link </label>
                                        <input type="text" class="form-control" id="gbp_link" name="gbp_link" aria-describedby="inputGroupPrepend" required placeholder="GBP Link"  value="{{$market->gbp_link}}">
                                        <span class="text-danger error_gbp_link" style="display:none;">This field is required.</span>
                                    </div>
                                     <!-- Website -->
                                     <div class="col-md-6">
                                        <label for="website" class="form-label">Website </label>
                                        <input type="text" class="form-control" id="website" name="website" aria-describedby="inputGroupPrepend" required placeholder="Website" value="{{$market->website}}">
                                        <span class="text-danger error_website" style="display:none;">This field is required.</span>
                                    </div>

                                    <!-- Rating -->
                                    <div class="col-md-6">
                                        <label for="rating" class="form-label">Rating </label>
                                        <input type="number" class="form-control" id="rating" name="rating" aria-describedby="inputGroupPrepend" required placeholder="Rating"  value="{{$market->rating}}">
                                        <span class="text-danger error_rating" style="display:none;">This field is required.</span>
                                    </div>

                                    <!-- Total Review -->
                                    <div class="col-md-6">
                                        <label for="total_review" class="form-label">Total Review </label>
                                        <input type="number" class="form-control" id="total_review" name="total_review" aria-describedby="inputGroupPrepend" required placeholder="Total Review" value="{{$market->total_review}}">
                                        <span class="text-danger error_total_review" style="display:none;">This field is required.</span>
                                    </div>
                                    <!-- claim_status -->
                                    <div class="col-md-6">
                                        <label for="claim_status" class="form-label">Claim Status <span class="text-danger"><b>*</b></span></label>
                                        <select class="form-select" aria-label="claim_status" name="claim_status">
                                            <option value="Claimed" {{ matchSelected($market->claim_status,'Claimed') }}>Claimed</option>
                                            <option value="Unclaimed" {{ matchSelected($market->claim_status,'Unclaimed') }}>Unclaimed</option>
                                        </select>
                                        <span class="text-danger error_claim_status" style="display:none;">This field is required.</span>
                                    </div>
                                    <!-- optimization_score -->
                                    <div class="col-md-4">
                                        <label for="optimization_score" class="form-label">Optimization Score</label>
                                        <input type="number" class="form-control" id="optimization_score" name="optimization_score" aria-describedby="inputGroupPrepend" required placeholder="Optimization Score" value="{{$market->optimization_score}}">
                                        <span class="text-danger error_optimization_score" style="display:none;">This field is required.</span>
                                    </div>
                                    <!-- local_ads -->
                                    <div class="col-md-4">
                                        <label for="local_ads" class="form-label">Local Ads</label>
                                        <input type="text" class="form-control" id="local_ads" name="local_ads" aria-describedby="inputGroupPrepend" required placeholder="Local Ads" value="{{$market->local_ads}}">
                                        <span class="text-danger error_local_ads" style="display:none;">This field is required.</span>
                                    </div>
                                    <!-- paid_ads -->
                                    <div class="col-md-4">
                                        <label for="paid_ads" class="form-label">Paid Ads </label>
                                        <input type="text" class="form-control" id="paid_ads" name="paid_ads" aria-describedby="inputGroupPrepend" required placeholder="Paid Ads"  value="{{$market->paid_ads}}">
                                        <span class="text-danger error_paid_ads" style="display:none;">This field is required.</span>
                                    </div>
                                    <!-- google_ranking -->
                                    <div class="col-md-6">
                                        <label for="google_ranking" class="form-label">Google Ranking </label>
                                        <input type="number" class="form-control" id="google_ranking" name="google_ranking" aria-describedby="inputGroupPrepend" required placeholder="Google Ranking"  value="{{$market->google_ranking}}">
                                        <span class="text-danger error_google_ranking" style="display:none;">This field is required.</span>
                                    </div>
                                    <!-- pack_ranking -->
                                    <div class="col-md-6">
                                        <label for="pack_ranking" class="form-label">3 Pack Ranking </label>
                                        <input type="number" class="form-control" id="pack_ranking" name="pack_ranking" aria-describedby="inputGroupPrepend" required placeholder="3 Pack Ranking" value="{{$market->pack_ranking}}" >
                                        <span class="text-danger error_pack_ranking" style="display:none;">This field is required.</span>
                                    </div>

                                    <!-- AI Suggested Services -->
                                    <div class="col-md-6">
                                        <label for="ai_suggested_services" class="form-label">AI Suggested Services</label>
                                        <input type="text" class="form-control" id="ai_suggested_services" name="ai_suggested_services" aria-describedby="inputGroupPrepend" required placeholder="AI Suggested Services"  value="{{$market->ai_suggested_services}}">
                                        <span class="text-danger error_ai_suggested_services" style="display:none;">This field is required.</span>
                                    </div>

                                    <!-- tags -->
                                    <div class="col-md-6">
                                        <label for="tags" class="form-label">Tags</label>
                                        <input type="text" class="form-control" id="tags" name="tags" aria-describedby="inputGroupPrepend" required placeholder="Tags"  value="{{$market->tags}}">
                                    </div>

                                    <!-- notes -->
                                    <div class="col-md-12">
                                        <label for="note" class="form-label">Note</label>
                                        <textarea class="form-control" max=100 id="note" name="note" placeholder="Note"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end row-->
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>

<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
    <script>
        var telInput = $('#phone_number');
        telInput.intlTelInput({
            utilsScript: 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js', // Update the URL to the correct one
            initialCountry: '{!! $countryCode  !!}', // Set the new country code
            separateDialCode: true
        });
        $(document).on('click', '.save_button', function(event) {
            event.preventDefault();
            var error = 0;
            if ($('#commonModal').find('form').hasClass('schedule_type')) {
                $('.error_name').hide();
                if ($('#commonModal').find('form').find('input[name="name"]').val().trim() == '') {
                    $('.error_name').show();
                    error = 1;
                }

                if (error == 0) {
                    let formdata = new FormData($('#commonModal').find('form')[0]);

                    $.ajax({
                            url: $('#commonModal').find('form').attr('action'),
                            data: formdata,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            success: function(response) {


                                if (response.success === true) {
                                    toastr.success(response.message, 'Success.');
                                    $('[name="opd_schedule_types_id"]').append(
                                        `<option value="${response.data.id}" selected>${response.data.name}</option>`
                                        );
                                    $('[name="opd_schedule_types_id"]').trigger('change');

                                    // hide modal
                                    $('#commonModal').modal('hide');
                                    $('#commonModal').find('.modal-body').html('');
                                    setTimeout(function() {
                                        //  alert('test');
                                        $('#create').trigger('click');
                                    }, 1000);
                                } else {
                                    toastr.error(response.message, 'Error!');
                                }
                            }
                        })
                        .fail(function(jqXHR, textStatus, errorThrown) {
                            console.log('AJAX request failed:', textStatus, errorThrown);
                            toastr.error('An error occurred during the request.', 'Error!');

                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        });
                }

            } else if ($('#commonModal').find('form').hasClass('orgazination_department')) {
                $('.error_name').hide();
                if ($('#commonModal').find('form').find('input[name="name"]').val().trim() == '') {
                    $('.error_name').show();
                    error = 1;
                }

                if (error == 0) {
                    let formdata = new FormData($('#commonModal').find('form')[0]);

                    $.ajax({
                            url: $('#commonModal').find('form').attr('action'),
                            data: formdata,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            success: function(response) {


                                if (response.success === true) {
                                    toastr.success(response.message, 'Success.');
                                    $('[name="organization_department_id"]').append(
                                        `<option value="${response.data.id}" selected>${response.data.name}</option>`
                                        );
                                    $('[name="organization_department_id"]').trigger('change');
                                    // hide modal
                                    $('#commonModal').modal('hide');
                                    $('#commonModal').find('.modal-body').html('');
                                    setTimeout(function() {
                                        //  alert('test');
                                        $('#create').trigger('click');
                                    }, 1000);
                                } else {
                                    toastr.error(response.message, 'Error!');
                                }
                            }
                        })
                        .fail(function(jqXHR, textStatus, errorThrown) {
                            console.log('AJAX request failed:', textStatus, errorThrown);
                            toastr.error('An error occurred during the request.', 'Error!');

                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        });
                }

            }

        })
        $(document).on('click', '.save_marketing', function(e) {
            e.preventDefault();

        if ($('#phone_number').val().trim() != '')
        {
            var dailcode_title = $('.phone_number_col .selected-flag').attr('title');
            var dailcode_array = dailcode_title.split("+");
            $('input[name="phone_number"]').val("+" + dailcode_array[1] + $('#phone_number').val());
        }

            $('.error_business_name').hide();
            $('.error_address').hide();
            $('.error_business_category_id').hide();
            $('.error_phone_number').hide();
            $('.error_email').hide();
            var error = 0;

            if ($('select[name="business_category_id"]').val() == null || $('select[name="business_category_id"]').val() == '') {
                $('.error_business_category_id').show();
                error = 1;
            }
            if ($('input[name="business_name"]').val() == null || $('input[name="business_name"]').val().trim() ==
                '') {
                $('.error_business_name').show();
                error = 1;
            }

            if ($('input[name="address"]').val() == null || $('input[name="address"]').val().trim() ==
                '') {
                $('.error_address').show();
                error = 1;
            }
            if ($('input[name="phone_number"]').val() == null || $('input[name="phone_number"]').val().trim() ==
                '') {
                $('.error_phone_number').show();
                error = 1;
            }
            if ($('input[name="email"]').val() == null || $('input[name="email"]').val().trim() == '') {
                $('.error_email').show();
                error = 1;
            }
            if (error == 0) {
                let formdata = new FormData($('#marketing')[0]);
                $.ajax({
                        url: "{{ route('marketing.update', $market->id) }}",
                        data: formdata,
                        processData: false,
                        contentType: false,
                        type: 'POST',
                        success: function(response) {
                            if (response.success === true) {
                                toastr.success(response.message, 'Success.');
                                window.location.href = "{{ route('marketing.index') }}";
                                // Replace with the URL you want to redirect to
                            } else {
                                toastr.error(response.message, 'Error!');
                            }
                        }
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        console.log('AJAX request failed:', textStatus, errorThrown);
                        toastr.error('An error occurred during the request.', 'Error!');
                    });
            }
            error = 1;
        })
    </script>
@endsection
