<style>
    /* Style the tooltip */
    a[title]::after {
        content: attr(title);
        background-color: black;
        /* Set the background color to black */
        color: white;
        /* Set the text color to white */
        padding: 5px 10px;
        /* Add padding for better spacing */
        position: absolute;
        z-index: 1;
        left: 50%;
        /* Center the tooltip horizontally */
        transform: translateX(-50%);
        /* Center the tooltip horizontally */
        border-radius: 5px;
        white-space: nowrap;
        font-size: 14px;
        opacity: 0;
        transition: opacity 0.2s;
        pointer-events: none;
    }

    /* Show the tooltip on hover */
    a[title]:hover::after {
        opacity: 1;
    }
</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Business Name</th>
                {{-- <th>Category</th> --}}
                <th>Address</th>
                <th>Website</th>
                {{-- <th> <i class="bi bi-globe"></i> </th> --}}
                <th>Contacts</th>
                <th>Rating</th>
                <th>Review</th>
                <th>Claim</th>
                <th>Score</th>
                <th class="thbutton">Status</th>
                @if(in_array('marketing-edit', $authRolePermissions))
                    <th class="thbutton">Edit</th>
                @endif
                @if(in_array('marketing-delete', $authRolePermissions))
                    <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if (count($data) > 0)
                @foreach ($data as $key => $list)
                    <tr>
                        <td>{{ $data->firstItem() + $key }}</td>
                        <td style="white-space: normal;"><strong>{{ $list->business_name }}<br></strong>
                            {{ $list->getBusinessCategory->name ?? '' }}</td>
                        <td style="white-space: normal;">
                            <span data-bs-toggle="tooltip" data-bs-html="true" title="{{ $list->address }}">
                                @php
                                    $words = str_word_count($list->address, 1);
                                    $last5Words = implode(' ', array_slice($words, -5));
                                @endphp
                                {{ $last5Words }}
                            </span>
                        </td>
                        <td>
                            @if (!empty($list->gbp_link))
                                <a href="{{ $list->gbp_link }}" target="_blank" title="GBP Link">
                                    <i style="font-size: large; margin-right: 2px;" class="fas fa-map-marker-alt"></i>
                                </a><br>
                            @endif
                            @if (!empty($list->website))
                                <a href="{{ $list->website }}" target="_blank" title="Website">
                                    <i style="font-size: large;" class="bi bi-globe"></i>
                                </a>
                            @endif
                        </td>
                        <td>
                            @if (!empty($list->phone_number))
                                <a href="tel:{{ $list->phone_number }}">{{ $list->phone_number }}</a><br>
                            @endif
                            @if (!empty($list->email))
                                <a href="https://mail.google.com/mail/?view=cm&fs=1&to={{ $list->email }}"
                                    target="_blank">{{ $list->email }}</a>
                            @endif
                        </td>

                        <td>{{ $list->rating }}</td>
                        <td>{{ $list->total_review }}</td>
                        <strong>
                            <td style="font-size: large; text-align:center">
                                @if ($list->claim_status === 'Claimed')
                                    <i class="bi bi-check-lg bi-3x text-success"></i>
                                @else
                                    <i class="bi bi-x-circle bi-3x text-danger"></i>
                                @endif
                            </td>
                        </strong>
                        <td>{{ $list->optimization_score }}</td>
                        <td>
                            <div class="form-check form-check-inline{{ $i }}">
                                <input class="form-check-input{{ $i }} btn-lg changeStatusCustom"
                                    type="checkbox" id="inlineCheckbox{{ $i }}"
                                    data-url="{{ route('marketing.changestatus') }}" data-id="{{ $list->id }}"
                                    data-status="{{ $list->status == '0' ? '1' : '0' }}"
                                    {{ $list->status == '1' ? 'checked' : '' }}>
                            </div>
                        </td>
                        @if(in_array('marketing-edit', $authRolePermissions))
                            <td>
                                <a href="{{ route('marketing.edit', $list->id) }}" class="btn btn-outline-secondary"
                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                    <i class="bi bi-pencil-square"></i>
                                </a>
                            </td>
                        @endif
                        @if(in_array('marketing-delete', $authRolePermissions))
                            <td>
                                <a data-url="{{ route('marketing.destroy') }}" data-id="{{ $list->id }}"
                                    class="btn btn-danger deleteDataCustom" href="#" class="text-danger"
                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                    <i class="bi bi-trash text-white"></i>
                                </a>
                            </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="8">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

<nav class="mt-2 row">
    <div class="col-lg-6 col-md-6 col-6 float-start">
        {!! $data->onEachSide(0)->render('marketings.pagination') !!}
    </div>
    <div class="col-lg-3 col-md-3 col-3 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
    </div>

    <div class="float-end mt-3 col-lg-3 col-md-3 col-3" style="text-align: right; width:auto; margin-top:10px;">
    <div class="btn-group mb-0">
        <a class="btn btn-outline-primary" href="{!! route('market.create') !!}"><i class="bi bi-cloud-download"></i> Marketing
            List Import</a>
    </div>
</div>
</nav>


</div>
<script>
    $(function() {
        $('[data-bs-toggle="tooltip"]').tooltip()
    })
</script>
