<form class="row g-3 auto-width account-category" action="{{ route('account-categories.store')}}" method="post" enctype='multipart/form-data' id="source_form">
    @csrf
    <div class="col-md-12">
        <label for="category_name" class="form-label">Category Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="category_name" name="category_name" aria-describedby="inputGroupPrepend" required maxlength="30">
        <span class="text-danger error_category_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="category_code" class="form-label">Category Code <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="category_code" name="category_code" aria-describedby="inputGroupPrepend" required maxlength="30">
        <span class="text-danger error_category_code" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="prefix" class="form-label">Prefix <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="prefix" name="prefix" aria-describedby="inputGroupPrepend" required maxlength="15">
        <span class="text-danger error_prefix" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="account_type_id" class="form-label">Account Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-control account_type_id" name="account_type_id">
            @foreach($types as $list)
            <option value="{{ $list->id }}" data-identifier="{!! strtolower($list->type_name) !!}" {!! $list->is_default == 1 ? 'selected' : '' !!}>{{ $list->type_name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_account_type_id" style="display:none;">This field is required.</span>
    </div>
</form>
