<form class="row g-3 auto-width account-type" action="{{ route('account-types.store')}}" method="post" enctype='multipart/form-data' id="source_form">
    @csrf
    <div class="col-md-6">
        <label for="type_name" class="form-label">Type Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="type_name" name="type_name" aria-describedby="inputGroupPrepend" required maxlength="30">
        <span class="text-danger error_type_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="type_code" class="form-label">Type Code <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="type_code" name="type_code" aria-describedby="inputGroupPrepend" required maxlength="30">
        <span class="text-danger error_type_code" style="display:none;">This field is required.</span>
    </div>
    <!--account groups -->
    <div class="col-md-6">
        <div>
            <label for="accounting_group_id" class="form-label">Account Group <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="accounting_group_id">
                <option value=""> ---Select Account Group ---</option>                
                @foreach ($accounting_groups as $list)
                <option value="{{ $list->id }}">{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_accounting_group_id" style="display: none;">This field is required.</span>
    </div>
    <!--account categories -->
    <div class="col-md-6">
        <div>
            <label for="account_category_id" class="form-label">Account Category <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="account_category_id">
                <option value=""> ---Select Account Category ---</option>                
                @foreach ($account_category as $list)
                <option value="{{ $list->id }}">{{ $list->category_name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_account_category_id" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="prefix" class="form-label">Prefix <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="prefix" name="prefix" aria-describedby="inputGroupPrepend" required maxlength="15">
        <span class="text-danger error_prefix" style="display:none;">This field is required.</span>
    </div>
</form>