<form class="row g-3 auto-width" action="{{ route('modules.update', $module->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-4">
        <label for="menu_name" class="form-label">Module Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="menu_name" name="menu_name" aria-describedby="inputGroupPrepend" required value="{!! old('menu_name', $module->menu_name) !!}">
        <span class="text-danger error_menu_name" style="display:none;">This field is required.</span>
    </div>
    <!-- Code -->
    <div class="col-md-4">
        <label for="code" class="form-label">Code <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" value="{{ $module->code }}" id="code" name="code" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_code" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-4">
        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" value="{{ old('priority', $module->priority) }}" id="priority" name="priority" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="priority" class="form-label">Parent Module</label>

        <select class="single-select form-control" name="parent_id">
            <option value="">Select parent module</option>
            @foreach($modules as $list)
            <option value="{{ $list->id }}" {!! matchSelected($list->id, $module->parent_id) !!}>{{ $list->menu_name }}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-4">
        <label for="priority" class="form-label">Voucher Master</label>

        <select class="single-select form-control" name="voucher_master_id">
            <option value="">Select Voucher Master</option>
            @foreach($voucher_master as $list)
            <option value="{{ $list->id }}" {!! matchSelected($list->id, $module->voucher_master_id) !!}>{{ $list->voucher_name }}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-4">
        <label for="icon" class="form-label">Icon <i class="bi bi-{!! $module->icon ?? 'list' !!}"></i></label>
        <input type="text" class="form-control" value="{!! $module->icon ?? 'list' !!}" id="icon" name="icon" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_icon" style="display:none;">This field is required.</span>
        <p>Note: You can find icons from <a href="https://icons.getbootstrap.com/" target="_blank">here</a>.</p>
    </div>
    <div class="col-md-4">
        <label for="name" class="form-label">Url</label>
        <input type="text" value="{{$module->url}}" class="form-control" id="url" name="url" aria-describedby="inputGroupPrepend" placeholder="Enter Url" required>
        <span class="text-danger error_url" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="module_type" class="form-label" >Module Type</label>
        <select class="form-select" aria-label="module_type" name="module_type">
            <option selected value="">Select Module Type</option>
            <option value="left_menu" {{ matchSelected($module->module_type,'left_menu') }}>Left Menu</option>
            <option value="top_menu" {{ matchSelected($module->module_type,'top_menu') }}>Top Menu</option>
            <option value="quick_menu" {{ matchSelected($module->module_type,'quick_menu') }}>Quick Menu</option>
        </select>
        <span class="text-danger error_target" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="target" class="form-label" >Target</label>
        <select class="form-select" aria-label="target" name="target">
            <option selected value="">Select Target</option>
            <option value="blank" {{ matchSelected($module->target,'blank') }}>Blank</option>
            <option value="self" {{ matchSelected($module->target,'self') }}>Self</option>
        </select>
        <span class="text-danger error_target" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="name" class="form-label">Route</label>
        <input type="text" class="form-control" id="route" value="{{$module->route}}" name="route" aria-describedby="inputGroupPrepend" placeholder="Enter Route"
            required>
        <span class="text-danger error_route" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="name" class="form-label">Route Named</label>
        <input type="text" class="form-control" value="{{$module->route_named}}" id="route_named" name="route_named" aria-describedby="inputGroupPrepend" placeholder="Enter Route Named"
            required>
        <span class="text-danger error_route_named" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-2">
        <label for="bg_color" class="form-label"> Color </span></label>
        <input type="color" class="form-control" style="width:55px;" id="color" name="color"
            aria-describedby="inputGroupPrepend"  value="{{ $module->color }}">
        <span class="text-danger error_color" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="name" class="form-label">Parameters</label>
        <input type="text" value="{{$module->parameters}}" class="form-control" id="parameters" name="parameters" aria-describedby="inputGroupPrepend" placeholder="Enter parameters" required>
        <span class="text-danger error_parameters" style="display:none;">This field is required.</span>
    </div>
</form>
