@extends('layouts.app')
@section('title','Enquiries')
@section('pages')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<!-- include summernote css/js -->
<link href="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
<style type="text/css">
    .add_btn {
        height: 30px; width: 30px; border-radius: 100%; padding: 0
    }
    .intl-tel-input {
        width: 100%;
    }
</style>
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Modules</div>
    <div class="breadcrumb-title px-3" style="border-right: none"> Information about Help & Support</div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('modules.infoStore', $id)}}" method="post" enctype='multipart/form-data'>
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                        @csrf
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <div class="col-md-12">
                                        <div class="input-group">
                                            <textarea id="summernote" name="summernote">{!! $module->summernote !!}</textarea>
                                        </div>
                                        @if ($errors->has('enquiry_category_id'))
                                            <span class="text-danger">{{ $errors->first('enquiry_category_id') }}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                          <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Save Information</button>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                  </form>
              </div>
          </div>
      </div>
  </div>
</div>
<!--end row-->
@endsection

@section('js')
<script src="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
<script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script>
    ClassicEditor
        .create( document.querySelector( '#summernote') )
        .then( newEditor => {
            editor = newEditor;
        })
        .catch( error => {
            console.error( error );
        });
        $(".ck-dropdown").find(`[data-cke-tooltip-text='Insert media']`).css("display", "none");
  </script>

@endsection

