<div class="table-responsive">
  <table class="table table-bordered align-middle" style="width:100%">
      <thead class="table-light">
          <tr>
              <th class="thbutton">Sl No</th>
              <th>Module Name</th>
              <th>Code</th>
              <th>Type</th>
              <th>Priority</th>
              <th>Permissions</th>
              <th class="thbutton">Status</th>
              <th class="thbutton">Module Info</th>
              @if(in_array('modules-edit', $authRolePermissions))
              <th class="thbutton">Edit</th>
              @endif
              @if(in_array('modules-delete', $authRolePermissions))
              <th class="thbutton">Delete</th>
              @endif
          </tr>
      </thead>
      <tbody>
        @php $i=1;@endphp
        @if(count($data)>0)
        @foreach($data as $key => $list)
        <tr>
            <td>{{$data->firstItem() + $key}}</td>
            <td class="menu_title"><i class="bi bi-{{$list->icon ?? 'list'}}"></i> {{$list->menu_name}}</td>
            <td>{{$list->code}}</td>
            <td class="{{ $list->parent_id == '' ? 'main_module' : 'sub_module' }}">{{ $list->parent_id == '' ? 'Main Module' : 'Sub Module' }}</td>
            <td class="text-center">{{$list->priority}}</td>
            <td class="text-center">
                <a href="{!! route('module-permissions', $list->id) !!}" class="btn btn-info button-large">
                    <i class="bi bi-shield-lock-fill text-white"> Edit</i>
                </a>
            </td>
            <td class="text-center">
                <div class="form-check form-check-inline{{$i}}">
                    <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('modules.changestatus')}}" data-id="{{$list->id}}" data-status="@if($list->status=='0'){{'1'}}@elseif($list->status=='1'){{'0'}}@endif" @if($list->status=='1'){{'checked'}}@elseif($list->status=='0'){{''}}@endif>
                </div>
            </td>
            @if(in_array('modules-edit', $authRolePermissions))
            <td class="text-center">
                <a href="{{route('modules.info', $list->id)}}" data-id="{{$list->id}}" class="btn btn-info info" title="Info">
                    <i class="bi bi-info-circle-fill text-white"></i>
                </a>
            </td>
            <td class="text-center">
                <button data-id="{{ $list->id }}" class="btn btn-warning edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                    <i class="bi bi-pencil-square text-white"></i>
                </button>
            </td>
            @endif
            @if(in_array('modules-delete', $authRolePermissions))
            <td class="text-center">
                <a data-url="{{route('modules.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                    <i class="bi bi-trash text-white"></i>
                </a>
            </td>
            @endif
        </tr>
        @php $i++; @endphp
        @endforeach
        @else
        <tr>
            <td colspan="8">No Data Found</td>
        </tr>
        @endif
    </tbody>
</table>
</div>
<nav class="float-start mt-2">
    <ul class="pagination">
        {!! $data->onEachSide(-1)->render('menu-module.pagination') !!}
    </ul>
</nav>
</div>

