<style type="text/css">
    .ui-widget-content {
        z-index: 1060;
    }
</style>
<form class="row g-3 auto-width update-patient" action="{{ route('appointment.update-patient', $sale_invoice->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('Post')
    <div class="col-md-12">
        <div>
            <label class="form-label">Patient Name <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" name="" id="patient_id" class="patient-select form-control" placeholder="Search Patient" value="{!! $patient->full_name ?? '' !!}">
            <ul class="searchResult"></ul>
            <div class="input-group-append" style="margin: auto 10px auto 0;">
                <button class="btn btn-secondary add_btn" id="create_patient" type="button">+</button>
                <button class="btn btn-primary edit_patient_btn" style="height: 40px;" type="button" data-id="{!! $patient->id ?? '' !!}"><i class="bi bi-pencil-square"></i></button>
            </div>
            <input type="hidden" name="patient_id" value="{!! $patient->id ?? '' !!}">
        </div>
        <span class="text-danger error_patient_id" style="display:none;">This field is required.</span>
    </div>
</form>

<script type="text/javascript">

    $('.patient-select').autocomplete({
        autoFocus: true,
        minLength: 0,
        source: function(request, response) {
            if (request.term.length < 2) {
                $('[name="patient_id"]').val('');
                return false;
            }

            $.ajax({
                url: "{{ route('billings-search-patients') }}",
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'get_patients_for_billing',
                    search_text: request.term
                },
                success: function(json) {
                    if (json.error) {
                        $('[name="patient_id"]').val('');
                        return false;
                    }
                    response($.map(json.result, function(item) {
                        return {
                            id: item.id,
                            name: item.name,
                            code: item.code,
                            gender: item.gender ,
                            phone_no: item.phone_no,
                            date_of_birth: item.date_of_birth,
                        };
                    }));
                }
            });
        },
        select: function(event, ui) {
            event.preventDefault();
            var age      = ui.item.date_of_birth != null ? ', ' + getAge(ui.item.date_of_birth) + ' Years' : '';
            var gender   = ui.item.gender != null ? ', ' + ui.item.gender : '';
            var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';
            var code = ui.item.code != null ? ', ' + ui.item.code : '';

            $(this).val(ui.item.name + code + gender + age + phone_no + "");
            $('[name="patient_id"]').val(ui.item.id);

            $.ajax({
              url     : '{!! route("opd-bookings.cart-product-update") !!}',
              method  : 'post',
              data    : {
                    "_token": $('meta[name ="csrf-token"]').attr('content'),
                    "patient_id": ui.item.id,
              }
            });
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function(ul, item) {
        var age      = item.date_of_birth != null && item.date_of_birth != '0000-00-00' ? ', ' + getAge(item.date_of_birth) + ' Years' : '';
        var gender   = item.gender != null ? ', ' + item.gender : '';
        var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';
        var code = item.code != null ? ', ' + item.code : '';

        return $("<li>")
            .append("<a>" + item.name + code + gender + age + phone_no + "</a>")
            .appendTo(ul);
    };


    
</script>