<div class="">
    <div class="row gx-3 gy-3">
        @if(count($doctors)>0)
        @foreach($doctors as $doctor)
        <div class="col-xl-4 col-lg-4 col-md-6">
            <div class="card">
                <div class="row gx-3">
                    <div class="col-lg-3 col-3">
                        <div class="doctor_img">
                            <a href="#doctorProfile{!! $doctor->id !!}" data-bs-toggle="modal" class="doctors-model" data-bs-target="#doctorProfile{!! $doctor->id !!}">
                                @if(isset($doctor->getAccount->account_images[0]->image))
                                <img class="img-fluid" src="{!! getTempUrl($doctor->getAccount->account_images[0]->image) !!}" loading="lazy" alt="{!! $doctor->getAccount?$doctor->getAccount->name:'' !!}">
                                @else
                                <img class="img-fluid" src="https://www.woodlandshospital.in/images/doctor-img/pinaki-banerjee.jpg" loading="lazy" alt="{!! $doctor->getAccount?$doctor->getAccount->name:'' !!}">
                                @endif
                                <i class="icon fal fa-info"></i>
                            </a>
                        </div>
                        <a class="view_profile" href="#doctorProfile" data-bs-toggle="modal" data-bs-target="#doctorProfile"><small>View Profile</small></a>
                    </div>
                    <div class="col-lg-9 col-9">
                        <h4 class="mb-0">Dr. {!! $doctor->getAccount?$doctor->getAccount->name:'' !!}</h4>
                        <p class="mb-2">{!! $doctor->getAccount->account_contact?$doctor->getAccount->account_contact->qualifications:'' !!}</p>
                        <div class="d-flex align-items-center">
                            <a href="{!! route('make.appointment',['id'=>$doctor->id,'booking_type'=>$bookingType]) !!}" class="btn btn-primary"><span>Book Appointment</span><i class="far fa-angle-right ms-2"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="doctorProfile{!! $doctor->id !!}" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="row">
                        <div class="col-lg-5 pe-0">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 col-4">
                                    <div class="modal_doctor">
                                        @if(isset($doctor->getAccount->account_images[0]->image))
                                            <img class="img-fluid" src="{!! getTempUrl($doctor->getAccount->account_images[0]->image) !!}" loading="lazy" alt="{!! $doctor->getAccount?$doctor->getAccount->name:'' !!}">
                                        @else
                                            <img class="img-fluid" src="https://www.woodlandshospital.in/images/doctor-img/pinaki-banerjee.jpg" loading="lazy" alt="{!! $doctor->getAccount?$doctor->getAccount->name:'' !!}">
                                        @endif
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-8">
                                    <div class="modal_doctor_profile text-xl-center text-lg-center mt-0 mt-xl-5 mt-lg-5">
                                        <h4 class="mb-0">Dr. {!! $doctor->getAccount?$doctor->getAccount->name:'' !!}</h4>
                                        @if(isset($doctor->getOrganizatioDepartment->name))
                                            <span class="d-block category mb-0">[{!! $doctor->getOrganizatioDepartment?$doctor->getOrganizatioDepartment->name:'' !!}]</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="content-body mt-3 mt-xl-0 mt-lg-0">
                                <div class="contact-form__wrapper">
                                    <div class="modal-header">
                                        <h4 class="fw-normal mt-1 mb-0 lh-1">Doctor Profile</h4>
                                        <!-- <h4 class="mb-0">[ FEES: {!! $results->total_amount??0 !!} <small class="fw-normal">/30 min</small> ]</h4> -->
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row gy-3">
                                            @if($doctor->qualification)
                                            <div class="col-lg-12">
                                                <span class="title">Specilitiy</span>
                                                <p class="point">
                                                    <span id="qualification">{!! $doctor->qualification !!}</span>
                                                </p>
                                            </div>
                                            @endif
                                            @if($doctor->experience)
                                            <div class="col-lg-6 col-6">
                                                <span class="title">Experience</span>
                                                <p class="point">{!! $doctor->experience !!}</p>
                                            </div>
                                            @endif
                                            @if($doctor->getOpdSchedule)
                                            <div class="col-lg-6 col-6">
                                                <span class="title">Types of</span>
                                                <p class="point">{!! $doctor->getOpdSchedule?$doctor->getOpdSchedule->name:'' !!}</p>
                                            </div>
                                            @endif
                                            @if($doctor->getDoctorLanguage)
                                            <div class="col-lg-6 col-6">
                                                <span class="title">Language</span>
                                                <p class="point">{!! $doctor->getDoctorLanguage?$doctor->getDoctorLanguage->name:'' !!}</p>
                                            </div>
                                            @endif
                                            @if($doctor->gap_between_two_patient)
                                            <div class="col-lg-6 col-6">
                                                <span class="title">Consultant</span>
                                                <p class="d-block point badge bg-warning" style="width:max-content;"><i class="far fa-clock me-1"></i>{{$doctor->gap_between_two_patient??15}} min</p>
                                            </div>
                                            @endif
                                        </div>
                                        <div class="d-flex align-items-center mt-4">
                                            <a href="{!! route('make.appointment',['id'=>$doctor->id]) !!}" class="btn btn-primary"><span>Book Appointment</span><i class="far fa-angle-right ms-2"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
        @else
        <div class="col-lg-12 col-12">
            <div class="alert alert-warning" role="alert">
                <p class="h3"> No Doctor Available Please Create Doctor</p>
                <br>
                <a href="{{ route('doctor.create') }}" class="btn btn-primary"><i class="bx bx-plus"></i> Add New Doctor</a>

            </div>

        </div>
        @endif
    </div>
</div>