@extends('layouts.app')

@section('title', 'Doctor List')

@section('pages')
<link rel="stylesheet" href="{{ asset('admin/css/calenderStyle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

    <!--breadcrumb-->
    <div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
        <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Doctor List </div>
        <div class="ps-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 p-0">
                    <li class="breadcrumb-item active" aria-current="page">Doctor List</li>
                </ol>
            </nav>
        </div>
        <div class="ms-auto">
             <div class="btn-group">
                <a href="{{route('opd-bookings.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            </div>
        </div>
    </div>
    <div class="row auto">
    <div class="col-xl-12 mx-auto">
    <section class="">
        <div class="doctor_filter">
            <div class="">
           
            <div class="card">
                <div class="card-body">
                <div class="row align-items-center justify-content-between">
                <div class="col-xl-3 col-lg-3 col-md-3">
                    <h3 class="sec_title mb-3 mb-lg-0 mb-xl-0">Our Doctors</h3>
                </div>
                <div class="col-xl-5 col-lg-5 col-md-5">
                    <form action="#!" method="post">
                        <div class="row gx-2 align-items-center">
                            <div class="col-lg-5 col-5">
                                <div class="input-group">
                                    <select class="single-select form-control" id="doctorSelect" name="specility" style="width:100%">
                                        <option selected disabled value="">Sort by: Specilitiy</option>
                                        @foreach($organization as $organiz)
                                        <option value="{!! $organiz->id !!}">{!! $organiz->name !!}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-7 col-7">
                                <div class="input-group search">
                                    <input class="form-control border" type="search" id="search_doctor" name="search" placeholder="Search here..." required="">
                                    <span class="input-group-append">
                                    </span>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                </div>
            </div>
            </div>
            </div>
        </div>
        <div class="doctor_listing mt-4" id="result">
            @include('opd-bookings.doctor-list-profile')
        </div>
    </section>
    </div>
    </div>
    <!--end row-->
@endsection
@section('js')
<script>
    $(document).ready(function () {
        function fetchData(selectedId, query) {
            $.ajax({
                type: 'POST',
                url: '{{ route("opd-bookings.doctor-List") }}',
                data: {
                    selectedId: selectedId,
                    query: query,
                    _token: '{{ csrf_token() }}'
                },
                success: function (response) {
                    $('#result').html(response);
                },
                error: function (error) {
                    console.error('Error:', error);
                }
            });
        }

        $('#doctorSelect, #search_doctor').on('change keyup', function () {
            var selectedId = $('#doctorSelect').val();
            var query = $('#search_doctor').val();

            fetchData(selectedId, query);
        });
    });
</script>

@endsection
