<div class="card style_table shadow-none" style="margin-bottom:0.8rem;">
    <div class="card-header d-flex align-items-center justify-content-between">
        @if($page == 'billing')
        <div style="width:100%" class="accordion-item">
            <div class="accordion-header" id="panelsStayOpen-headingTwo">
                <div class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                    <div class="col-md-6">
                        @endif
                        <h6 class="mb-0">Total Products in Cart <i class="bi bi-cart"></i> ({!! isset($data['products']) ? count($data['products']) : '0' !!})</h6>
                        @if($page == 'billing')
                    </div>
                </div>
                <div class="col-md-12" align="right">
                    @endif
                    @if($id > 0)
                    <a href="{!! route('opd-bookings.edit-cart-billing', $id) !!}" type="button" class="btn btn-outline-primary" id="checkout"><i class="bx bx-plus"></i> Add New</a>
                    @elseif($page != 'billing')
                    <a href="{!! route('appointment.billing') !!}" type="button" class="btn btn-outline-primary" id="checkout"><i class="bx bx-plus"></i> Add New</a>
                    @endif
                </div>
                @if($page == 'billing')
            </div>
            <div style="" id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse @if($page != 'billing'){{'show'}}@else{{''}}@endif" aria-labelledby="panelsStayOpen-headingTwo">
                <div class="accordion-body">
                    @endif
                    <div class="card-body pb-0">
                        <div class="table-responsive">
                            <table id="example" class="table table-bordered align-middle" style="width:100%">
                                <thead class="table-light">
                                    <tr>
                                        <th class="text-start">ITEM NAME</th>
                                        <th class="text-end">PRICE</th>
                                        <th class="text-end">DIS.%</th>
                                        <th class="text-end">DIS.AMT.</th>
                                        <th class="text-end">AMOUNT</th>
                                        @if($page != 'billing' || $page == 'edit')
                                        <th class="thbutton">Delete</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $i = 1;$product_price = 0; @endphp
                                    @if(isset($data['products']) && count($data['products']) > 0)
                                    @foreach($data['products'] as $key => $list)
                                    <tr class="cart-products" data-patient_id="{{$list['product_id']}}">
                                        <td class="text-start">{{$list['product'] ?? ''}} <br> @if(isset($list['hsncode']) && $list['hsncode'] != '')<b>Code:</b> {{$list['hsncode'] ?? ''}},@endif @if($list['brand']!='N/A')<b>Brand:</b> {{$list['brand'] ?? ''}}@endif</td>
                                        @if($page != 'billing' || $page == 'edit')
                                        <td><input type="text" name="product_price" data-patient_id="{{$list['product_id']}}" class="form-control bg-white" value="{{$list['product_price'] ?? ''}}" placeholder="00.00" style="text-align: right;"></td>
                                        <td><input type="text" name="per_discount" data-patient_id="{{$list['product_id']}}" class="form-control bg-white" value="{{$list['per_discount'] ?? ''}}" placeholder="00.00" style="text-align: right;"></td>
                                        <td><input type="text" name="flat_discount" data-patient_id="{{$list['product_id']}}" class="form-control bg-white" value="{{$list['flat_discount'] ?? ''}}" placeholder="00.00" style="text-align: right;"></td>
                                        <td align="right">{{$list['amount'] ?? ($list['product_price'] ?? '')}}</td>
                                        <td class="text-center">
                                            <a style="line-height:24px;" data-url="{{route('opd-bookings.cart-product-remove')}}" data-id="{{$key}}" data-patient_id="{{$list['product_id']}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="left" title="Delete">
                                                <i class="bi bi-trash text-white"></i>
                                            </a>
                                        </td>
                                        @else
                                        <td align="right">{{ convertDecimelPoint($list['product_price']) ?? ''}}</td>
                                        <td align="right">{{$list['per_discount'] ?? ''}}</td>
                                        <td align="right">{{ convertDecimelPoint($list['flat_discount']) ?? ''}}</td>
                                        <td class="text-dark" align="right"><b class="text-dark">{{ convertDecimelPoint($list['amount']) ?? (convertDecimelPoint($list['product_price']) ?? '')}}</b></td>
                                        @endif
                                        
                                        @php $product_price += preg_replace("/[^0-9.]/", "", $list['amount']); @endphp
                                    </tr>
                                    @php $i++; @endphp
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="9">No Data Found</td>
                                    </tr>
                                    @endif

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            @if($page == 'billing')
        </div>
    </div>
</div>
@endif
<script type="text/javascript">
    $(document).ready(function() {
        $('#checkout').html('Total Amount {!! $product_price !!} <i class="bi bi-cart-fill"></i> Checkout')
    });
</script>
@if( $product_price > 0)
<script type="text/javascript">
    $(document).ready(function() {
        $('#checkout').removeClass('btn-outline-primary');
        $('#checkout').addClass('btn-primary');
    });
</script>
@endif