@extends('layouts.app')
@section('title', 'Appointment Reschedule')
@section('pages')
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<link rel="stylesheet" href="{{ asset('admin/css/calenderStyle.css') }}">
<style>
    .booking_slot {
        position: relative;
    float: left;
    padding: 5px 5px;
    margin-left: 5px;
    margin-bottom: 5px;
    line-height: 1.42857143;
    color: #059e66;
    text-decoration: none;
    background-color: #fff;
    border: 2px solid #00d67d;
    border-radius: 10%;
    font-size: 20px;
    width: 60px;
    line-height: 19px;
    }
    .booking_date {
        position: relative;
        float: left;
        /* padding: 11px 6px; */
        padding-left: 5px;
        margin-left: 5px;
        margin-bottom: 5px;
        line-height: 1.42857143;
        color: #059e66;
        text-decoration: none;
        background-color: #fff;
        border: 2px solid #00d67d;
        border-radius: 15%;
        font-size: 19px;
        width: 35%;
        line-height: 14px;
        padding-right: 5px;
        padding-top: 15px;
        padding-bottom: 15px;
    }
   .disabled {
    color: red;
    width: 8px;
    height: auto;
    border-radius: 50%;
}
.doctor_img img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    -o-object-fit: cover;
    object-position: center;
    -o-object-position: center;
    transition: all .3s ease-in-out;
}
</style>


<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Appointment Reschedule</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item active" aria-current="page">
                   </li>
            </ol>
        </nav>
    </div>
    
    @php $bookingId = request()->segment(3)??''; @endphp
    <div class="ms-auto">
        <div class="btn-group">
        <a class="text-dark" style="padding: 7px;font-size:18px"><b>Current Details: Serial No {{$opdData->appointment_serial_no??''}}, 
                    {{$opdData->appointment_date_time?date('h:i A',strtotime($opdData->appointment_date_time)):''}}, 
                    {!! $opdData->getShiftNames->name??'' !!}, {{ $opdData->appointment_date_time?formatedDate($opdData->appointment_date_time):''}}</b> 
                </a>
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>

<!--end breadcrumb-->
<div class="row auto">
    <div class="col-xl-5 col-md-5">
        <div class="row">
            <div class="col-xl-12 col-md-12">
                <div class="card style_table">
                    <div class="card-body pt-2 ps-3" style="border-radius:0px;">
                        <div class="row">
                            <div class="col-md-2">
                                <div class="doctor_img">
                                    @if(isset($doctor->getAccount->account_images[0]->image))
                                    <img class="img-fluid" src="{!! getTempUrl($doctor->getAccount->account_images[0]->image) !!}" loading="lazy" alt="{!! $doctor->getAccount?$doctor->getAccount->name:'' !!}" style="border-radius: 50px;">
                                    @else
                                    <img class="img-fluid" src="https://www.woodlandshospital.in/images/doctor-img/pinaki-banerjee.jpg" loading="lazy" alt="doctor name" style="border-radius: 50px;">
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="txt" style="height:20">
                                    <span class="badge bg-warning"><i class="far fa-clock me-1"></i>{{$doctor->gap_between_two_patient??15}} min</span>
                                    {{--<span style="float: inline-end">Fees:M- ₹.{!! $resultsM->total_amount??0 !!}</span>
                                    <br>
                                    <span style="float: inline-end;margin-right:-102px">Fees:A- ₹.{!! $resultsA->total_amount??0 !!}</span>
                                    <br>
                                    <span style="float: inline-end">Fees:E- ₹.{!! $resultsE->total_amount??0 !!}</span>--}}
                                    <div class="col-md-12">
                                        <span class="mt-1 mb-0 h4"> Dr. {!! $doctor->getAccount?$doctor->getAccount->name:'' !!}</span>
                                    </div>
                                    {{--@if(isset($doctor->getOrganizatioDepartment))
                                    <span class="category mb-0">[{!! $doctor->getOrganizatioDepartment?$doctor->getOrganizatioDepartment->name:'' !!}]</span>
                                    @endif
                                    <h3 class="border-top mb-1"></h3>
                                    <p class="mb-2 mb-xl-1 mb-lg-1 mt-2">{!! $doctor->getAccount->account_contact?$doctor->getAccount->account_contact->qualifications:'' !!}</p>--}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="card style_table">
                    <div class="card-body pt-2 ps-3" style="border-radius:0px;">

                        <div class="elegant-calencar d-md-flex" style="margin-left: 1px;">
                            <div class="wrap-header d-flex align-items-center">
                                <p id="reset">reset</p>
                                <div id="header" class="p-0">
                                    <div class="pre-button d-flex align-items-center justify-content-center"><i class="bi bi-chevron-left font-32"></i></div>
                                    <div class="head-info">
                                        <div class="head-day"></div>
                                        <!-- <div class="head-month"></div> -->
                                    </div>
                                    <div class="next-button d-flex align-items-center justify-content-center"><i class="bi bi-chevron-right font-32"></i></div>
                                </div>
                            </div>
                            <div class="calendar-wrap">
                            <div class="head-month" style="border-bottom: 3px solid #2bd281;color:#2a3246;font-weight: bold"></div>
                                <table id="calendar">
                                    <thead>
                                        <tr>
                                            <th class="{{ !in_array(7, $days_array)?'disabled':'' }}">Sun</th>
                                            <th class="{{ !in_array(1, $days_array)?'disabled':'' }}">Mon</th>
                                            <th class="{{ !in_array(2, $days_array)?'disabled':'' }}">Tue</th>
                                            <th class="{{ !in_array(3, $days_array)?'disabled':'' }}">Wed</th>
                                            <th class="{{ !in_array(4, $days_array)?'disabled':'' }}">Thu</th>
                                            <th class="{{ !in_array(5, $days_array)?'disabled':'' }}">Fri</th>
                                            <th class="{{ !in_array(6, $days_array)?'disabled':'' }}">Sat</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td ></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="mt-2"> <span class="text-danger"><b>Note:</b></span> <b>The color of the available day is black and the color of the not available day is <span class="text-danger">red</span>.</b></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-7 col-md-7">
        <div class="row">
            <div class="col-md-12 mb-2" id="confirm_btn_div">
                <div class="card style_table">
                    <div class="card-body" style="border-radius:0px;">
                        <div class="row gx-2 custom_grid align-items-end gx-0 mt-4 mb-3">
                            <!-- <div class="col-lg-4 col-md-4 col-4">
                                <span id="shift_name" class="h6"></span>
                            </div> -->
                            <!-- <div class="col-lg-6 col-md-6 col-6">
                                <div class="input-group">
                                    <label class="form-label">Booking Type <span class="text-danger"><b></b></span></label>
                                    <select class="form-control br-0" id="appointment_status" name="appointment_status" disabled readonly>
                                        <option value="Booking" {{ $bookingType=="booking"?"selected":"" }}>Booking</option>
                                        <option value="Appointment" {{ $bookingType=="appointment"?"selected":"" }}>Appointment</option>
                                    </select>
                                </div>
                            </div> -->
                            <div class="col-lg-12 col-md-12 col-12 text-center">
                                <a type="button" class="btn btn-primary" id="confirm_btn" style="width: 50% !important;" href="#">Confirm Reschedule<i class="bi bi-arrow-right ms-1"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12 mb-2">
                <div class="card style_table">
                    <div class="card-body" style="border-radius:0px;">
                        <div class="col-md-12" id="shifts_days">
                            @include('opd-bookings.reschedule.opd-shift-timing')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
        <!--end row-->
        @endsection
        @section('js')
        <script type="text/javascript" src="{{ asset('admin/js/calenderJquery.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/js/calenderMain.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/js/calenderPopper.js') }}"></script>
        <script>
            $(document).ready(function() {
                $('#calendar').on('click', 'td', function() {
                    $('#confirm_btn_div').hide();
                    var selectedDate = $(this).text();
                    var month_year = $('.head-month').text();
                    var year = month_year.split(" - ");
                    var selectedMonth = year[0];
                    var selectedYear = year[1];
                    // Creating a Date object to get the day
                    var selectedDay = new Date(selectedYear, monthIndex(selectedMonth), selectedDate);
                    var dayOfWeek = getDayOfWeek(selectedDay.getDay()); // Function to get day of the week
                    $.ajax({
                        type: "POST",
                        url: "{{ route('opd-bookings.reschedule', $bookingId) }}",
                        data: {
                            selectedDate: selectedDate,
                            selectedMonth: selectedMonth,
                            selectedYear: selectedYear,
                            dayOfWeek: dayOfWeek
                        },
                        success: function(response) {
                            $('#shifts_days').html(response);
                        },
                        error: function(error) {
                            console.log(error);
                        }
                    });
                });
                // Function to convert month name to month index
                function monthIndex(monthName) {
                    var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
                    return monthNames.indexOf(monthName);
                }
                // Function to get day of the week
                function getDayOfWeek(dayIndex) {
                    var daysOfWeek = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
                    return daysOfWeek[dayIndex];
                }
                $('#confirm_btn_div').hide();
                $(document).on('click', '.booking_slot', function() {
                    var url = $(this).data('url');
                    var time = $(this).data('time');
                    var date = $(this).data('date');
                    var shift_name = $(this).data('shift_name');
                    var slot = $(this).data('slot');
                   
                    var newUrl = url;
                    $("#time").html(time);
                    // $("#date").html(date);
                    $("#shift_name").html('' + shift_name + ' ' + date);
                    $("#slot").html(slot);
                    // $("#confirm_btn").attr("href", newUrl);
                    $('#confirm_btn_div').show();
                    $('.booking_slot').removeClass('booking_slot_selected');
                    $('.booking_slot').removeClass('text-white');
                    $(this).addClass('booking_slot_selected');
                    $(this).addClass('text-white');
                });
                $(document).on('change', '#appointment_status', function() {
                    var url = $('.booking_slot_selected').data('url');
                    var newUrl = url
                    // console.log(newUrl);
                });
                $(document).on('click', '#confirm_btn', function() {
                    var url = $('.booking_slot_selected').data('url');
                    console.log(url);
                    var newUrl = url;
                    window.location.href = newUrl;
                });
            });
        </script>