<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">SL. No.</th>
                <th>Booking</th>
                <th>Patient Details</th>
                <th>Doctor Details</th>
                <th>Appointment</th>
                <th style="text-align: right;">Bill Amount</th>
                <th class="thbutton">Balance</th>
                @if(in_array('opd-booking-print', $authRolePermissions))
                <th class="thbutton">Slip</th>
                @endif
                
                @if(in_array('opd-booking-edit', $authRolePermissions))
                <th class="thbutton">Convert</th>
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('opd-booking-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                @php $Receive = TransactionCalculationReceiveAmount($list->id,'OPD_BOOKING'); @endphp
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>@php  $booking_date_time = \Illuminate\Support\Carbon::parse($list->booking_date_time); @endphp
                        <a href="{{route('opd-appointment.show',$list->id)}}?redirect=opd-bookings"><b>{{$list->booking_no}}</b></a>
                            <br>
                            {{$booking_date_time->format('d-m-Y') ?? ''}}<br>
                            {{$booking_date_time->format('h:i A') ?? '' }}
                        </td>
                        <td>
                        
                            {{$list->getPatient->account_title->name ?? ''}}
                            {{$list->getPatient->name ?? ''}}<br>
                            {{$list->getPatient->account_contact->gender->name ?? ''}}{{ isset($list->getPatient->account_contact->date_of_birth) && isset($list->getPatient->account_contact->gender) ? ', ' : '' }} {{ isset($list->getPatient->account_contact->date_of_birth) ? age($list->getPatient->account_contact->date_of_birth) . ' years' : '' }}
                            <br>
                            {{ isset($list->getPatient->account_contact->phone_no) ?'Ph:'. $list->getPatient->account_contact->phone_no:''}}
                        </td>
                        <td>
                            {{$list->getDoctorAccount->account_title->name ?? ''}}
                            {{$list->getDoctorAccount->name ?? ''}}
                            <br>
                            @if(isset($list->getCreatedBy->prepared_by))
                            <div style="color:#aaa">By: {!! $list->getCreatedBy->prepared_by??'' !!}</div>
                            @endif
                            Source: {{'Walk In'}}
                        </td>
                        <td>@php  $appointment_date_time = \Illuminate\Support\Carbon::parse($list->appointment_date_time); @endphp
                            {{$appointment_date_time->format('d-m-Y') ?? ''}}<br>
                            {{$appointment_date_time->format('h:i A') ?? '' }}<br>
                            <b>Token No: {{$list->appointment_serial_no ?? ''}}</b>
                        </td>
                        <td style="text-align: right;">
                            Total: {{ convertDecimelPoint($Receive['totalBilling']) ?? ''}}
                            @if($Receive['dueAmount']>0)
                            <br>
                            <span class="badge btn-secondary text-white">DUE: {{ convertDecimelPoint($Receive['dueAmount']) ?? ''}}</span>
                            @endif
                            @if($Receive['receivedAmount']>0)
                                <br>
                                <a href="{!! route('billing-collection-list',['invoice_id'=>$list->id,'module_code'=>'OPD_BOOKING']) !!}?redirect=opd-bookings" class="">
                                    <b>Received: {{ convertDecimelPoint($Receive['receivedAmount']) ?? ''}}</b>
                                </a>
                            @endif

                        </td>
                        <td class="text-center">
                            {!! $Receive['dueAmount'] > 0 ? '<a href="' . route('billing-collection',['invoice_id'=>$list->id,'voucher_type'=>'opd-booking','payment_type'=>'advance']) .'?redirect=opd-bookings" class="btn-sm btn-success text-white"><i class="bi bi-coin"></i> Collect</a>' : ' <i class="bi bi-check-circle text-success" style="font-size: 30px;" title="Amount Collected."></i>' !!}
                        </td>
                        
                        @if(in_array('opd-booking-print', $authRolePermissions))
                        <td class="text-center">
                            <a class="btn btn-info" href="{{route('opd-bookings.slip',$list->id)}}"><i class="bi bi-printer text-white"></i></a>
                        </td>
                        @endif
                      
                        @if(in_array('opd-booking-edit', $authRolePermissions))
                        <td>
                            <a href="{{route('opd-bookings.convert',$list->id)}}" class="btn-sm btn-primary text-white"><i class="bi bi-arrow-clockwise"></i> Convert</a>
                        </td>
                      
                        <td class="text-center">
                            <a href="{{route('opd-bookings.edit', $list->id)}}" class="btn btn-warning" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </a>
                        </td>
                        
                        @endif
                        @if(in_array('opd-booking-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('opd-bookings.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                     
                       
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="18">No Data Found</td>
                </tr>
            @endif
        </tbody>

    </table>
</div>

<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
        {!! $data->onEachSide(0)->render('opd-bookings.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
    </div>
</nav>
</div>
