<form class="row g-3 auto-width" method="post" action="{{ route('operations.update', $data->id) }}">
    @csrf
    @method('put')
    <div class="col-md-12">
        <label for="operation" class="form-label">Name<span class="text-danger"><b>*</b></span></label>
        <input type="text" value="{{ $data->operation }}" class="form-control" name="operation" aria-describedby="inputGroupPrepend" placeholder="name">
        <span class="text-danger error_operation_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="type" class="form-label">Category<span class="text-danger"><b>*</b></span></label>
        <select class="form-control category_id" name="category_id">
            @foreach($operation_categories as $operation_category)
                <option {{ ($data->category_id == $operation_category->id) ? 'selected' : '' }} value="{{ $operation_category->id }}">{{ $operation_category->category }}</option>
            @endforeach
        </select>
        <span class="text-danger error_category_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="priority" class="form-label">Priority<span class="text-danger"><b>*</b></span></label>
        <input type="number" value="{{ $data->priority }}" class="form-control" name="priority" aria-describedby="inputGroupPrepend">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
</form>