<form class="row g-3 auto-width planAndPackages" action="{{ route('plan-and-packages.store')}}" method="post" enctype='multipart/form-data'>
    @csrf
    <!-- biling interval -->
    <div class="col-md-12">
        <label class="form-label">Plane Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" name="plan_name" aria-describedby="inputGroupPrepend" required placeholder="Plane Name">
        @if ($errors->has('plan_name'))
        <span class="text-danger">{{ $errors->first('plan_name') }}</span>
        @endif
        <span class="text-danger error_plan_name" style="display: none;">This field is required.</span>
    </div>
    {{-- industry type --}}
    <div class="col-md-12">
        <div>
            <label for="industry_type_id" class="form-label">Industry Type <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="form-control" name="industry_type_id">
                @foreach($industry as $list)
                <option value="{{ $list->id }}">{{ $list->name }}</option>
                @endforeach
            </select>
            <div class="input-group-append" style="margin: auto 10px;">
                <button class="btn btn-success add_btn" id="create_industry_type" type="button"  style="border-radius: 28.5px;
                height: 32px;
                width: 32px;">+</button>
            </div>
        </div>
        <span class="text-danger error_industry_type_id" style="display: none;">This field is required.</span>
    </div>
    <!-- per_year -->
    <div class="col-md-12">
        <label for="plan_code" class="form-label">Plan Code <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" name="plan_code" aria-describedby="inputGroupPrepend" required placeholder="Plan Code" >
    </div>
    <!-- days -->
    <div class="col-md-12">
        <label for="features_details" class="form-label">Features Details </label>
        <textarea class="form-control" name="features_details" rows="15" required placeholder="Features Details"></textarea>
    </div>
</form>
<script type="text/javascript">
    
    // Adding Industry Type
    $(document).on('click', '#create_industry_type', function() {
        $('#commonModalLabel').text('Add New Industry Type');
        $('.save_button_span').text('Save Industry Type');
        $.ajax({
            url: "{!! route('industry-type.create') !!}",
            success: function(data) {
                $('#commonModal').find('.modal-body').html('');
                $('#commonModal').find('.modal-body').html(data);
            }
        })
    })
    // submitform
</script>