<form class="row g-3 auto-width" action="{{ route('plan-and-packages.update', $data->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('PUT')
    <div class="col-md-12">
        <label class="form-label">Plane Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" name="plan_name" aria-describedby="inputGroupPrepend" required placeholder="Plane Name" value="{!! $data->plan_name ?? '' !!}">
    </div>
    <div class="col-md-12">
        <label for="validationCustom01" class="form-label">Industry Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="industry_type_id">
            @foreach ($industry as $list)
                <option value="{{ $list->id }}" {{ $list->id == $data->industry_type_id ? 'selected':'' }}>{{ $list->name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_industry_type_id" style="display:none;">This field is required.</span>
    </div>
    <!-- per_year -->
    <div class="col-md-12">
        <label for="plan_code" class="form-label">Plan Code <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" name="plan_code" aria-describedby="inputGroupPrepend" required placeholder="Plan Code" value="{!! $data->plan_code ?? '' !!}">
    </div>
    <!-- days -->
    <div class="col-md-12">
        <label for="features_details" class="form-label">Features Details </label>
        <textarea class="form-control" name="features_details" rows="15" required placeholder="Features Details">{!! $data->features_details ?? '' !!}</textarea>
    </div>
</form>
<script type="text/javascript">
    
    // Adding Industry Type
    $(document).on('click', '#create_industry_type', function() {
        $('#commonModalLabel').text('Add New Industry Type');
        $('.save_button_span').text('Save Industry Type');
        $.ajax({
            url: "{!! route('industry-type.create') !!}",
            success: function(data) {
                $('#commonModal').find('.modal-body').html('');
                $('#commonModal').find('.modal-body').html(data);
            }
        })
    })
    // submitform
</script>