<form class="row g-3 auto-width" action="{{ route('price-settings.update', $PriceSetting->id)}}" method="post" enctype='multipart/form-data'
    id="source_form">
    @csrf
    @method("PATCH")
     <!-- Price Settings-->
    <div class="col-md-6">
        <label for="master_voucher_id" class="form-label">Master Voucher  <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="master_voucher_id">
            @foreach ($voucher_master as $list)
                <option value="{{ $list->id }}" {{$list->id == $PriceSetting->master_voucher_id ? 'selected' : '' }}>{{ $list->voucher_name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_master_voucher_id" style="display:none;">This field is required.</span>
    </div>
    <!-- Price Settings-->
    <div class="col-md-6">
        <label for="price_setting" class="form-label">Price Setting <span class="text-danger"><b>*</b></span></label>
        <select class="form-select" aria-label="price_setting" name="price_setting">
            <option value="whole_sale_price" {{ matchSelected($PriceSetting->price_setting,'whole_sale_price') }}>Whole Sale Price</option>
            <option value="sale_price" {{ matchSelected($PriceSetting->price_setting,'sale_price') }}>Sale Price</option>
            <option value="maximum_retail_price" {{ matchSelected($PriceSetting->price_setting,'maximum_retail_price') }}>Maximum Retail Price</option>
            <option value="purchase_price" {{ matchSelected($PriceSetting->price_setting,'purchase_price') }}>Purchase Price</option>
            <option value="min_sale_price" {{ matchSelected($PriceSetting->price_setting,'min_sale_price') }}>Min Sale Price</option>

            <option value="min_sale_price" {{ old('price_setting') == 'min_sale_price' ? 'selected' : '' }}>Min Sale Price</option>
        </select>
        <span class="text-danger error_price_setting" style="display:none;">This field is required.</span>
    </div>
    
</form>
