<div class="table-responsive">
	<table id="example" class="table table-bordered align-middle" style="width:100%">
	    <thead class="table-light">
		    <tr>
		        <th class="thbutton">Sl No</th>
		        <th>Name</th>
                <th>Unit Type</th>
		        <th>Code</th>
                <th>Priority</th>
		        <th>Description</th>
		        <th class="thbutton">Default</th>
		        <th class="thbutton">Status</th>
                @if(in_array('primary-unit-edit', $authRolePermissions))
		        	<th class="thbutton">Edit</th>
		        @endif
                @if(in_array('primary-unit-delete', $authRolePermissions))
		        	<th class="thbutton">Delete</th>
		        @endif
		    </tr>
	    </thead>
	    <tbody> 
	    	@php $i=1;@endphp
            @if(count($data)>0)
		    	@foreach ($data as $key => $primary)
				    <tr>
				        <td class="text-center">{{$data->firstItem() + $key}}</td>
				        <td>{{ $primary->name }}</td>
				        <td>{{ $primary->unit_type }}</td>
				        <td>{{ $primary->code }}</td>
                        <td>{{ $primary->priority }}</td>
				        <td>{{ $primary->description }}</td>
				        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('primary-units.change-default')}}" data-id="{{$primary->id}}" data-status="{{$primary->is_default=='0' ? '1' : '0'}}" {{ $primary->is_default=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
				        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('primary-units.changestatus')}}" data-id="{{$primary->id}}" data-status="{{$primary->status=='0' ? '1' : '0'}}" {{ $primary->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('primary-unit-edit', $authRolePermissions))
                        <td class="text-center">
                            <button data-id="{{ $primary->id }}" class="btn btn-warning edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('primary-unit-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('primary-units.destroy')}}" data-id="{{$primary->id}}" class="btn btn-danger deleteDataCustom" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
				    </tr>
			    @endforeach
			@else
                <tr>
                    <td colspan="6">No Data Found</td>
                </tr>
            @endif
	    </tbody>
	</table>
</div>
<nav class="row mt-3">
    <div class="col-md-8">
        {!! $data->onEachSide(0)->render('primary-unit.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
	 @if(auth()->user()->can('primary-unit-import'))
      <div class="col-md-2" style="text-align: right;">
        <div class="btn-group mb-0">
            <a class="btn btn-outline-primary" href="{!! route('primary-units.import-create') !!}"><i class="bi bi-upload"></i> Upload from Excel</a>
        </div>
      </div>
    @endif
</nav>
</div>