@extends('layouts.app')
@section('title','Print Style Settings')
@section('pages')
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Print Style Settings</div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-primary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('print-style-settings.store')}}" method="post" enctype='multipart/form-data'>
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                        @csrf
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Print Style Settings</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-4">
                                        <div class="d-flex justify-content-between">
                                            <label for="name" class="form-label">Show Header</label>
                                            <input class="form-check-input btn-lg" name="show_header" type="checkbox" id="show_header" data-status="1" {{ $data->show_header=='1' ? 'checked' : ''}}>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="d-flex justify-content-between">
                                            <label for="show_footer" class="form-label">Show Footer</label>
                                            <input class="form-check-input btn-lg" name="show_footer" type="checkbox" id="show_footer" data-status="1" {{ $data->show_footer=='1' ? 'checked' : ''}}>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="d-flex justify-content-between">
                                            <label for="show_watermark" class="form-label">Show Watermark</label>
                                            <input class="form-check-input btn-lg" name="show_watermark" type="checkbox" id="show_watermark" data-status="1" {{ $data->show_watermark=='1' ? 'checked' : ''}}>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="show_in_header" class="form-label">Show In Header</label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-select" name="show_in_header">
                                                <option value="company_details" {!! matchSelected($data->company_details,'company_details') !!}>Company Details</option>
                                                <option value="letter_head" {!! matchSelected($data->company_details,'letter_head') !!}>Letter Head</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="letter_head" class="form-label">Letter Head File</label>
                                        </div>
                                        <div class="input-group">
                                            <input class="form-control" name="letter_head" type="file" id="letter_head">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="watermark_transparency" class="form-label">Watermark Transparency</label>
                                        </div>
                                        <div class="input-group">
                                            <input class="form-control btn-lg" type="number" name="watermark_transparency" id="watermark_transparency" value="50">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="watermark" class="form-label">Watermark</label>
                                        </div>
                                        <div class="input-group">
                                            <input class="form-control btn-lg" type="file" name="watermark" id="watermark">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="layout" class="form-label">Orientation</label>
                                        </div>
                                        <div class="input-group">
                                            <select name="layout" class="form-select">
                                                <option value="portrait" {!! matchSelected($data->layout,'portrait') !!}>Portrait</option>
                                                <option value="landscape" {!! matchSelected($data->layout,'landscape') !!}>Landscape</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="page_size" class="form-label">Page Size</label>
                                        </div>
                                        <div class="input-group">
                                            <select name="page_size" class="form-select">
                                                <option value="a4">A4</option>
                                                <option value="letter">Letter</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                          <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Save Account Details</button>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                  </form>
              </div>
          </div>
      </div>
  </div>
</div>
<!--end row-->
@endsection
@section('js')
    <script type="text/javascript">
        $(document).on('click', '[name="show_header"]', function() {
            
        });
    </script>
@endsection