<form class="row g-3 auto-width alternative_units" action="{{ route('product-alternative-units.store')}}" method="post" enctype='multipart/form-data'>
    <!-- For validation comment on -->
    <!-- <form class="row g-3 was-validated"> -->
    @csrf
    <div class="col-md-12">
        <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend" required placeholder="Name">
        <span class="text-danger error_name" style="display: none;">This field is required.</span>
    </div>
    <div class="col-6">
        <label for="code" class="form-label">Code<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control code" id="code" name="code" aria-describedby="inputGroupPrepend" placeholder="Code">
        <span class="text-danger error_code" style="display:none;">This field is required.</span>
    </div>
    <div class="col-6">
        <label for="unit_type" class="form-label">Unit Type<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control unit_type" id="unit_type" name="unit_type" aria-describedby="inputGroupPrepend" placeholder="Unit Type">
        <span class="text-danger error_unit_type" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <div>
            <label for="primary_unit_id" class="form-label">Primary Unit <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="primary_unit_id">
                @foreach($primary_unit as $list)
                <option value="{{ $list->id }}">{{ $list->name }}</option>
                @endforeach
            </select>
            <div class="input-group-append" style="margin: auto 10px;">
                <button class="btn btn-success add_btn" id="create_primary_unit" type="button"> + </button>
            </div>
        </div> 
        <span class="text-danger error_primary_unit_id" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="description" class="form-label">Description</label>
        <textarea class="form-textarea" rows="1" name="description"></textarea>
    </div>
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $priority + 1 !!}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
</form>