<form class="row g-3 auto-width" action="{{ route('product-alternative-units.update', $alternative_unit->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-12">
        <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" value="{!! $alternative_unit->name !!}" name="name" aria-describedby="inputGroupPrepend" required placeholder="Name">
        <span class="text-danger error_name" style="display: none;">This field is required.</span>
    </div>
    <div class="col-6">
        <label for="code" class="form-label">Code<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control code" id="code" name="code" aria-describedby="inputGroupPrepend" placeholder="Code" value="{!! $alternative_unit->code !!}">
        <span class="text-danger error_code" style="display:none;">This field is required.</span>
    </div>
    <div class="col-6">
        <label for="unit_type" class="form-label">Unit Type<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control unit_type" id="unit_type" name="unit_type" aria-describedby="inputGroupPrepend" placeholder="Unit Type" value="{!! $alternative_unit->unit_type !!}">
        <span class="text-danger error_unit_type" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <div>
            <label for="primary_unit_id" class="form-label">Primary Unit <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="primary_unit_id">
                @foreach($primary_unit as $list)
                <option value="{{ $list->id }}" {!! $alternative_unit->primary_unit_id == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                @endforeach
            </select>
            <div class="input-group-append" style="margin: auto 10px;">
                <button class="btn btn-success add_btn" id="create_primary_unit" type="button"> + </button>
            </div>
        </div> 
        <span class="text-danger error_primary_unit_id" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="description" class="form-label">Description</label>
        <textarea class="form-textarea" rows="1" name="description">{!! $alternative_unit->description !!}</textarea>
    </div>
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $alternative_unit->priority !!}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
</form>