<form class="row g-3 auto-width" action="{{ route('product-attributes.update', $product->id) }}" method="post"
    enctype='multipart/form-data' id="source_form">
    @csrf
    @method('PATCH')
    <div class="col-md-12">
        <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend" required value="{{ $product->name }}">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-12">
        <label for="code" class="form-label">Code <span class="text-danger"><b>*</b></span></label>
        <input readonly type="text" class="form-control" id="code" name="code" aria-describedby="inputGroupPrepend" required value="{{ $product->code }}">
        <span class="text-danger error_code" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="product_attribute_type_id" class="form-label">Product Attribute Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="product_attribute_type_id">
            @foreach ($types as $list)
                <option value="{{ $list->id }}" {{ $list->id == $product->product_attribute_type_id ? 'selected' : '' }}>
                    {{ $list->name }}
                </option>
            @endforeach
        </select>
        <span class="text-danger error_chart_of_account_type_id" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="priority" class="form-label">Priority</label>
        <input type="text" class="form-control" id="priority" name="priority" aria-describedby="inputGroupPrepend"
            required value="{{ $product->priority }}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-12">
        <label for="description" class="form-label">Description</label>
        <textarea class="form-control" max=100 id="description" name="description">{{ $product->description }}</textarea>
    </div>
</form>
