<form class="row g-3 auto-width create_batch" action="{{ route('product.batch.store')}}" method="post" enctype='multipart/form-data' id="create_batch_store">
    @csrf
    @method('POST')
    <div class="col-md-4">
        <label for="batch" class="form-label">Batch / Number <span class="text-danger"><b>*</b></span></label>
        <input type="text" name="batch" class="form-control" value="{!! old('batch') !!}" placeholder="Enter batch" style="text-transform: uppercase;">
        <span class="text-danger error_batch" style="display:none;">This field is required.</span>
    </div>
    <div class="col-4">
        <label for="exp_month" class="form-label">Month of Expiry <span class="text-danger"><b>*</b></span></label>
        <select id="exp_month" name="exp_month" class="form-control">
            <option value="">-Select Month-</option>
            @foreach(months() as $key => $value)
                <option value="{!! $key !!}">{!! $key !!} - {!! $value  !!}</option>
            @endforeach
        </select>
        <span class="text-danger error_exp_month" style="display:none;">This field is required.</span>
    </div>
    <div class="col-4">
        <label for="exp_year" class="form-label">Year Of Expiry <span class="text-danger"><b>*</b></span></label>
        <select id="exp_year" name="exp_year" class="form-control">
            <option value="">-Select Year-</option>
            @php
            $currentYear = date('Y');
            @endphp
            @for($year = $currentYear; $year <= $currentYear + 200; $year++) 
                <option value="{!! $year !!}">{!! $year !!}</option>
            @endfor
        </select>
        <span class="text-danger error_exp_year" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="mrp" class="form-label">MRP <span class="text-danger"><b>*</b></span></label>
        <input type="number" name="mrp" class="form-control mrp" value="{!! old('mrp') !!}" placeholder="Enter MRP">

        <span class="text-danger error_mrp" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="sale_price" class="form-label">Sale Price(DP)</label>
        <input type="number" name="sale_price" class="form-control" value="{!! old('sale_price') !!}" placeholder="Enter Sale Price">
    </div>
    <div class="col-md-4">
        <label for="purchase_price" class="form-label">Purchase Price </span></label>
        <input type="number" name="purchase_price" class="form-control" value="{!! old('purchase_price') !!}" placeholder="Enter Purchase Price">
        <span class="text-danger error_purchase_price" style="display:none;">This field is required.</span>
    </div>
    
   

    <input type="hidden" name="product_id" value="{!! $productId??'' !!}">
</form>
<script>
    $(document).on('keyup','[name="mrp"]', function(e) {
        var mrp = $(this).val();
        $('[name="sale_price"]').val(mrp);
    });
</script>
