@extends('layouts.app')
@section('title', 'Add Modules for Product Feature')
@section('pages')
    <style type="text/css">
        .breadcrumb-title {
            border-right: none;
        }
    </style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
        <div class="breadcrumb-title col-md-6"> Add Modules for Product Feature
        </div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-md-end mb-0">
                    <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="93"
                            data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                    <li class="breadcrumb-item active" aria-current="page">Add Modules for Product Feature </li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->

    <div class="card style_table shadow-none radius-5 min-height">
        <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
            <div class="row gx-2">
                <div class="col-lg-3 col-md-3 col-8">
                    <div class="position-relative">
                        <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i
                                class="bi bi-search"></i></div>
                        <input class="form-control ps-5" type="search" id="search" placeholder="Search">
                    </div>
                </div>

                <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
                    <i class="bi bi-funnel"></i>
                    <select class="form-select sorting sorting-box" id="" name="example_length"
                        aria-controls="example">
                        <option value="10">Show: 10</option>
                        <option value="30">Show: 30</option>
                        <option value="50">Show: 50</option>
                    </select>
                </div>

                <div class="col-lg-7 col-md-7">
                    <div class="ms-auto float-md-end">

                        <div class="btn-group">
                            <a href="{{ route('product-features.index') }}" class="btn btn-outline-secondary me-1"><i
                                    class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                        </div>

                        <div class="btn-group">
                            <button type="button" class="btn btn-primary" id="create" data-bs-toggle="modal"
                                data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="card-body" id="tables">

            @include('product-feature-modules.table')

            <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
            <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
            <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
        </div>

        <script>
             /***************** Global Delay Fucntion ***************/
             function delay(callback, ms) {
                var timer = 0;
                return function() {
                    var context = this,
                        args = arguments;
                    clearTimeout(timer);
                    timer = setTimeout(function() {
                        callback.apply(context, args);
                    }, ms || 0);
                };
            }

            $(document).ready(function() {
                $("body").on("click", '.add_all_features', function(event) {
                    var code = "{!! request()->segment(3) !!}";

                    if (code == '') {
                        Swal.fire({
                            title: 'Product code is missing for this product!',
                            icon: 'info'
                        });

                        return false;
                    }

                    Swal.fire({
                        title: 'Are you sure you want to add all modules?',
                        icon: 'warning',
                        showDenyButton: true,
                        showCancelButton: false,
                        confirmButtonText: 'Yes',
                        denyButtonText: 'No',
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{!! route('all-modules.store') !!}",
                                method: 'POST',
                                data: {'code' : code},
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                beforeSend: function(xhr) {
                                    // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                                },
                                success: function(response) {
                                    if (response.status == 'success') {
                                        location.reload();
                                    }
                                },
                                error: function(data) {
                                    console.log("error ", data);

                                    if (status == 1) {
                                        changeStatus.parent().find('.ui-switcher').attr(
                                            'aria-checked', false);
                                    } else {
                                        changeStatus.parent().find('.ui-switcher').attr(
                                            'aria-checked', true);
                                    }
                                }
                            });
                        }
                    });
                });

                function clear_icon() {
                    $('#id_icon').html('');
                    $('#post_title_icon').html('');
                }

                function fetch_data(page, sort_type, sort_by, query) {
                    $.ajax({
                        url: "?page=" + page + "&sortby=" + sort_by + "&sorttype=" + sort_type + "&query=" +
                            query,
                        success: function(data) {
                            $('#tables').html('');
                            $('#tables').html(data);
                            $(document).ready(function() {
                                $.switcher('#tables .changeStatusCustom');
                            });
                        }
                    })
                }


                $(document).on('click', '#create', function() {
                    $('#commonModalLabel').text('Product feature modules');
                    $('.save_button_span').text('Create');
                    $.ajax({
                        url: "{!! route('product-feature-modules.create', $id) !!}",
                        success: function(data) {
                            $('#commonModal').find('.modal-body').html('');
                            $('#commonModal').find('.modal-body').html(data);
                        }
                    })
                })

                $(document).on('click', '.save_button', function(event) {
                    event.preventDefault();
                    // $('.error_test_name').hide();
                    var error = 0;

                    var selectedOptions = $("#test_item_id option:selected").toArray();
                    var ids = [];
                    selectedOptions.forEach(function(option, index) {
                        var optionValue = $(option).val();
                        var optionText = $(option).text();
                        ids.push(optionValue);
                    });

                    // if (ids.length == 0) {
                    //   $('.error_module_code').show();
                    //   error = 1;
                    // }
                    $('#commonModal').find('form').find('[name="product_code"]');

                    if (error == 0) {
                        $('#commonModal').find('form').submit();
                    }
                    error = 1;
                })

                  /******** Change Like below ********/
                $(document).on('keyup', '#search', delay(function() {
                    var query = $('#search').val();

                    if (query.length < 2 && query.length != 0) {
                        return;
                    }

                    var column_name = $('.sorting').val();
                    var sort_type = $('#hidden_sort_type').val();
                    var page = 1 ? 1 : (this).attr('href').split('page=')[1];
                    fetch_data(page, sort_type, column_name, query);
                }, 700));

                $('body').on('change', '.sorting', function() {
                    var column_name = $(this).val();
                    var order_type = $(this).data('sorting_type');
                    var reverse_order = '';
                    var page = 1 ? 1 : (this).attr('href').split('page=')[1];
                    var query = $('#search').val() ? $('#search').val() : '';
                    fetch_data(page, reverse_order, column_name, query);
                });

                $('body').on('click', '.pager a', function(event) {
                    event.preventDefault();
                    $('#hidden_page').val(page);
                    var page = $(this).attr('href').split('page=')[1];
                    var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                    var sort_type = $('#hidden_sort_type').val();
                    var query = $('#search').val() ? $('#search').val() : '';
                    $('li').removeClass('active');
                    $(this).parent().addClass('active');
                    fetch_data(page, sort_type, column_name, query);
                });

                /*********change status**********/
                $("body").on("click", '.changeStatusCustom', function(event) {
                    dataString = {
                        "id": $(this).data('id'),
                        "status": $(this).data('status')
                    };
                    var UrlValue = $(this).data('url');
                    var status = $(this).data('status');
                    var changeStatus = $(this);
                    var btn = $(this);

                    Swal.fire({
                        title: 'Are you sure you want to change status?',
                        icon: 'warning',
                        showDenyButton: true,
                        showCancelButton: false,
                        confirmButtonText: 'Yes',
                        denyButtonText: 'No',
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: UrlValue,
                                method: 'post',
                                data: dataString,
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                beforeSend: function(xhr) {
                                    // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                                },
                                success: function(response) {
                                    if (response.success) {
                                        var ErroMsg = $(this).printErrorMsg(response
                                            .message);
                                        $(this).Toastshow('success', ErroMsg);

                                        var page = $('.pager').find('.active a').attr(
                                            'href') == undefined ? 1 : $('.pager').find(
                                            '.active a').attr('href').split('page=')[1];
                                        var column_name = $('.sorting').val() ? $(
                                            '.sorting').val() : '';
                                        var sort_type = $('#hidden_sort_type').val();
                                        var query = $('#search').val() ? $('#search')
                                        .val() : '';

                                        fetch_data(page, sort_type, column_name, query);
                                    } else {
                                        var ErroMsg = $(this).printErrorMsg(response
                                            .message);
                                        if (ErroMsg === '') {
                                            ErroMsg = "Something went wrong!";
                                        }
                                        $(this).Toastshow('error', ErroMsg);

                                        if (status == 1) {
                                            changeStatus.parent().find('.ui-switcher').attr(
                                                'aria-checked', false);
                                        } else {
                                            changeStatus.parent().find('.ui-switcher').attr(
                                                'aria-checked', true);
                                        }
                                    }
                                },
                                error: function(data) {
                                    console.log("error ", data);

                                    if (status == 1) {
                                        changeStatus.parent().find('.ui-switcher').attr(
                                            'aria-checked', false);
                                    } else {
                                        changeStatus.parent().find('.ui-switcher').attr(
                                            'aria-checked', true);
                                    }
                                }
                            });
                        } else if (result.isDenied) {
                            var page = $('.pager').find('.active a').attr('href') == undefined ? 1 : $(
                                '.pager').find('.active a').attr('href').split('page=')[1];
                            var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                            var sort_type = $('#hidden_sort_type').val();
                            var query = $('#search').val() ? $('#search').val() : '';

                            fetch_data(page, sort_type, column_name, query);
                        }
                        //return false;
                    });
                    //return false;
                });
                /*********delete data**********/
                $("body").on("click", '.deleteDataCustom', function(event) {
                    dataString = {
                        "id": $(this).data('id')
                    };
                    var UrlValue = $(this).data('url');
                    var btn = $(this);

                    Swal.fire({
                        title: 'Are you sure you want to delete this?',
                        icon: 'warning',
                        showDenyButton: true,
                        showCancelButton: false,
                        confirmButtonText: 'Yes',
                        denyButtonText: 'No',
                    }).then((result) => {
                        /* Read more about isConfirmed, isDenied below */
                        if (result.isConfirmed) {
                            $.ajax({
                                url: UrlValue,
                                method: 'post',
                                data: {
                                    "_token": $('meta[name="csrf-token"]').attr('content'),
                                    "id": $(this).data('id')
                                },
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                beforeSend: function(xhr) {
                                    // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                                },
                                success: function(response) {
                                    if (response.success) {
                                        var ErroMsg = $(this).printErrorMsg(response
                                            .message);

                                        $(this).Toastshow('success', ErroMsg);

                                        var page = $('.pager').find('.active a').attr(
                                            'href') == undefined ? 1 : $('.pager').find(
                                            '.active a').attr('href').split('page=')[1];
                                        var column_name = $('.sorting').val() ? $(
                                            '.sorting').val() : '';
                                        var sort_type = $('#hidden_sort_type').val();
                                        var query = $('#search').val() ? $('#search')
                                        .val() : '';

                                        fetch_data(page, sort_type, column_name, query);
                                    } else {
                                        var ErroMsg = $(this).printErrorMsg(response
                                            .message);
                                        $(this).Toastshow('error', ErroMsg);
                                    }
                                },
                                error: function(data) {
                                    console.log("error ", data);
                                }
                            });
                        }
                    });
                });

                $(".tablecontents").sortable({
                    items: "tr",
                    cursor: 'grab',
                    opacity: 0.7,
                    update: function() {
                        sendOrderToServer();
                    }
                });

                function sendOrderToServer() {
                    var order = [];
                    $('tr.row1').each(function(index, element) {
                        order.push({
                            id: $(this).attr('data-id'),
                            position: index + 1
                        });
                        $(this).find($('td.priority')).text(index + 1);
                        $(this).find($('td.item_sno')).text(index + 1);
                    });

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: "{{ route('product-test-packages-reorder') }}",
                        data: {
                            order: order,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            if (response.status == true) {
                                toastr.success(response.message);
                            } else {
                                toastr.success('Error');
                            }
                        }
                    });
                }
            });
        </script>
    @endsection
