<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Name</th>
                <th>Trade Name</th>
                <th>State</th>
                <th>Country</th>
                <th>Company</th>
                <th>Address 1</th>
                <th>Address 2</th>
                <th>Place</th>
                <th>GST N0</th>
                <th class="thbutton">Default</th> 
                <th class="thbutton">Status</th>
                @if(in_array('product-warehouse-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('product-warehouse-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                <tr>
                        <td>{{$i++}}</td>
                        <td>{{$list->name ?? 'N/A'}}</td>
                        <td>{{$list->trade_name?? 'N/A'}}</td>
                        <td>{{$list->getState->name?? 'N/A'}}</td>
                        <td>{{$list->getCountry->name ?? 'N/A'}}</td>
                        <td>{{$list->getCompany->name ?? 'N/A'}}</td>
                        <td>{{$list->address_1}}</td>
                        <td>{{$list->address_2}}</td>
                        <td>{{$list->place}}</td>
                        <td>{{$list->gst_no}}</td>
                        <td></td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('product-warehouse.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('product-warehouse-edit', $authRolePermissions))
                        <td>
                            <a href="{{route('product-warehouse.edit',$list->id)}}" class="btn btn-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </a>
                        </td>
                        @endif
                        @if(in_array('product-warehouse-delete', $authRolePermissions))
                        <td>
                            <a data-url="{{route('product-warehouse.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="13">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="row align-items-center mt-2">
    <div class="col-md-10">
         {!! $data->onEachSide(0)->render('product-warehouse.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
</nav>
</div>

