<form class="row g-3 update_product" action="{{ route('products.modal.store')}}" method="post" enctype='multipart/form-data' id="update_product">
    @csrf
    <div class="col-md-12">
        <div>
            <label for="name" class="form-label">Product / Item Name <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <input type="text" name="name" class="form-control" value="{!! old('name') !!}" placeholder="Add NEW PRODUCT #">
        </div>
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <div>
            <label for="hsncode" class="form-label">HSN / SAC Code</label>
        </div>
        <div class="input-group">
            <input type="text" name="hsncode" class="form-control" value="{!! old('hsncode') !!}" placeholder="Enter Product hsncode">
        </div>
    </div>
    <div class="col-md-4">
        <div>
            <label class="form-label">Tax Slab <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class=" form-control" id="tax_slab_id" name="tax_slab_id" required>
                <option value="">--Select--</option>
                @foreach($tax_master as $list)
                <option value="{{ $list->id}}" >{{$list->name}}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_tax_slab_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <div>
            <label class="form-label">Primary Unit <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class=" form-control" id="primary_unit_id" name="primary_unit_id" required>
                <option value="">--Select--</option>
                @foreach($primary_units as $list)
                <option value="{{ $list->id}}" {!! $list->is_default==1?'selected':'' !!}>{{$list->name}}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_group_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="mrp" class="form-label">MRP <span class="text-danger"><b>*</b></span></label>
        <input type="hidden" name="product_price_id" value="">
        <input type="number" name="mrp" class="form-control mrp" value="" placeholder="Enter MRP">

        <span class="text-danger error_mrp" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="sale_price" class="form-label">Sale Price(DP)</label>
        <input type="number" name="sale_price" class="form-control" value="" placeholder="Enter Sale Price">
    </div>
    <div class="col-md-4">
        <label for="purchase_price" class="form-label">Purchase Price </span></label>
        <input type="number" name="purchase_price" class="form-control" value="" placeholder="Enter Purchase Price">
        <span class="text-danger error_purchase_price" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <div>
            <label for="convertion_factor" class="form-label">Conversion Factor </label>
        </div>
        <div class="input-group">
            <input type="number" name="convertion_factor" class="form-control" value="{!! old('convertion_factor', '1') !!}">
        </div>
    </div>
    <div class="col-md-4">
        <div>
            <label class="form-label">Product Packaging <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="  form-control" id="product_packaging_id" name="product_packaging_id" required>
                <option value="">--Select--</option>
                @foreach($product_packaging as $list)
                <option value="{{ $list->id}}">{{$list->name}}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_product_packaging_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <div>
            <label class="form-label">Business Division <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="  form-control" id="business_division_id" name="business_division_id" required>
                <option value="">--Select--</option>
                @foreach($business_division as $list)
                <option value="{{ $list->id}}" >{{$list->name}}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_business_division_id" style="display:none;">This field is required.</span>
    </div>
    
    <div class="col-md-4">
        <div>
            <label class="form-label">Brand <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class=" form-control" id="brand_id" name="brand_id" required>
                <option value="">--Select--</option>
                @foreach($brands as $list)
                <option value="{{ $list->id}}" >{{$list->name}}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_brand_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <div>
            <label class="form-label">Product Category <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class=" form-control" id="category_id" name="category_id" required>
                <option value="">--Select--</option>
                @foreach($categories as $list)
                <option value="{{ $list->id}}" >{{$list->name}}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_category_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <div>
            <label class="form-label">Product Salt/Group </label>
        </div>
        <div class="input-group">
            <select class="  form-control" id="composition_id" name="composition_id" required>
                <option value="">--Select--</option>
                @foreach($groups as $list)
                <option value="{{ $list->id}}" >{{$list->name}}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_composition_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label for="batch" class="form-label">Batch / Number <span class="text-danger"><b>*</b></span></label>
        <input type="text" name="batch" class="form-control" value="" placeholder="Enter batch" style="text-transform: uppercase;">
        <span class="text-danger error_batch" style="display:none;">This field is required.</span>
    </div>
    <div class="col-4">
        <label for="exp_month" class="form-label">Month of Expiry <span class="text-danger"><b>*</b></span></label>
        <select id="exp_month" name="exp_month" class="form-control">
            <option value="">-Select Month-</option>
            @foreach(months() as $key => $value)
                <option value="{!! $key !!}" >{!! $key !!} - {!! $value  !!}</option>
            @endforeach
        </select>
        <span class="text-danger error_exp_month" style="display:none;">This field is required.</span>
    </div>
    <div class="col-4">
        <label for="exp_year" class="form-label">Year Of Expiry <span class="text-danger"><b>*</b></span></label>
        <select id="exp_year" name="exp_year" class="form-control">
            <option value="">-Select Year-</option>
            @php
            $currentYear = date('Y');
            @endphp
            @for($year = $currentYear; $year <= $currentYear + 200; $year++) 
                <option value="{!! $year !!}">{!! $year !!}</option>
            @endfor
        </select>
        <span class="text-danger error_exp_year" style="display:none;">This field is required.</span>
    </div>
</form>
<script>
    $(document).on('keyup','[name="mrp"]', function(e) {
        var mrp = $(this).val();
        $('[name="sale_price"]').val(mrp);
    });
</script>