<div class="row g-3">
    <div class="col-md-8">
        <div>
            <label for="name" class="form-label">Product / Item Name <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <input type="text" name="search_product" class="form-control" value="{!! old('search_product') !!}" placeholder="Search Product Name,Code,Hsc Code (Press Enter To Search)...">
        </div>
        <span class="text-danger search_product" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <button type="button" class="btn btn-primary mt-4" id="search_button"><i class="bi bi-search"></i> Search Product</button>
    </div>
</div>
<div class="row mt-4">
    <div class="col-md-12">
        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <th>Sl</th>
                <th>Product Name</th>
                <th>MRP</th>
               {{-- <th>Batch </th>--}}
                <th>Stock</th>
                <th>Expiry Date</th>
                <th class="text-center">Restock</th>
                <th>Re-Stock QTY</th>
                <tbody id="tbody"></tbody>
            </table>
        </div>
    </div>
</div>
<script>

$(document).on('keyup', 'input[name="search_product"]', function(e) {
    if (e.keyCode === 13) { // Detect Enter key press
        performSearch();
    }
});

$(document).on('click', '#search_button', function() { // Detect button click
    performSearch();
});

function performSearch() {
    $('.search_product').hide();
    var error = 0;
    var search_product_input = $('input[name="search_product"]');
    
    if (search_product_input.val().trim() === '') {
        $('.search_product').show();
        error = 1;
        setTimeout(function() {
            $('.search_product').hide();
        }, 3000);
    }

    if (error === 0) {
        var url = `{!! route('product-search-stock') !!}`;
        var search_product = search_product_input.val();
        
        $.ajax({
            url: url,
            method: 'GET',
            data: {
                search_product: search_product
            },
            success: function(data) {
                $('#tbody').html(data);
            }
        });
    }
}



    $(document).on('click', '.restock', function() {
        var product_id = $(this).data('product_id');
        var qty        = $('#re_stock_qty_'+product_id).val();
            var url = `{!! route('stock-short-list.store') !!}`;
            $.ajax({
                url: url,
                method: 'POST',
                data: {
                    product_id: product_id,
                    qty:qty
                },
                success: function (response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');
                            performSearch();
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
            });
        
    });
</script>