@extends('layouts.app')
@section('title', 'Price List')
@section('pages')
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />

    <style type="text/css">
        .breadcrumb-title {
            border-right: none;
        }

        .dataTables_filter {
            display: none;
        }

        div.dt-buttons {
            float: right;
            padding: 8px;
        }
    </style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
        <div class="breadcrumb-title col-md-6"> Price List</div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-md-end mb-0">
                    <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="33"
                            data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                    <li class="breadcrumb-item" aria-current="page">Price List</li>
                    <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Price List </li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->
   <div class="card shadow-none radius-5 min-height">
        <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
            <div class="row gx-2 custom_grid align-items-end gx-0 mt-4 mb-3">
                 <!-- Brand-->
                <div class="col-lg-3 col-md-2 col-2">
                    <div class="input-group">
                      <label class="form-label">All Brands <span class="text-danger"><b></b></span></label>
                      <select class="form-control br-0" id="product_brand" name="product_brand" required>
                        <option value="">Select Brands</option>
                        @foreach($brand as $list)
                        <option value="{{$list->id}}" {!! $selectedBrand == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                        @endforeach
                      </select>
                    </div>
                </div>

                <!-- Product Category-->
                <div class="col-lg-3 col-md-2 col-2">
                    <div class="input-group">
                      <label class="form-label">All Category <span class="text-danger"><b></b></span></label>
                      <select class="form-control br-0" id="product_category" name="product_category" required>
                        @foreach ($product_category as $list)
                            <option value="{{ $list->id }}" {!! $selectedCategory == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                        @endforeach
                      </select>
                    </div>
                </div>

                <!-- Product Group-->
                <div class="col-lg-3 col-md-2 col-2">
                    <div class="input-group">
                      <label class="form-label">All Group <span class="text-danger"><b></b></span></label>
                      <select class="form-select" id="product_group" name="product_group" aria-controls="example">
                        <option selected value="">Select Groups</option>
                            @foreach ($product_group as $list)
                                <option value="{{ $list->id }}" {!! $selectedGroup == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                            @endforeach
                      </select>
                    </div>
                </div>
                <div class="col-lg-3 col-md-2 col-2">
                    <div class="btn-group mb-2 ms-auto float-md-end">
                        <a href="{{route('products.index')}}" class="btn btn-lg btn-outline-secondary mx-2"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>

                    </div>
                </div>

                <div class="row mt-2">
                  <div class="col-lg-12 col-md-12 col-12 text-center">
                    <button class="btn btn-primary mb-3 mt-3" id="submit" type="button" style="height: 40px; width: 25% !important;"><i class="bi bi-search"></i> Search</button>
                  </div>
                </div>

                <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
                <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
                <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
                <hr>
                    <div class="card-body" >
                        <div class="row" style="">
                            <div class="col-md-12" id="tables">
                            </div>
                        </div>
                    </div>
            </div>
        </div>
    </div>
        <!-- @include('products.price-table') -->
    @endsection
    @section('js')
    <script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>
    <script>
       $('[name="from_date"]').datepicker({
        format: "{!! $companyDateFormate??'dd-mm-yyyy' !!}",
        autoclose: true,
        }).datepicker("setDate", new Date());
      $('[name="to_date"]').datepicker({
      format: "{!! $companyDateFormate??'dd-mm-yyyy' !!}",
      autoclose: true,
      }).datepicker("setDate", new Date());
      $(document).ready(function() {

        function clear_icon() {
          $('#id_icon').html('');
          $('#post_title_icon').html('');
        }

        function fetch_data(product_brand, product_category, product_group) {
          $.ajax({
            url: "?product_brand=" + product_brand + "&product_category=" + product_category + "&product_group=" + product_group,
            success: function(data) {
              $('#tables').html('');
              $('#tables').html(data);
              $(document).ready(function() {
                $.switcher();
              });
              $('#example').dataTable({
                paging: false,
                searching: false,
                info: false
              });
            }
          })
        }

        $("body").on("click", '#submit', function(event) {
          var product_brand    = $('#product_brand').val();
          var product_category = $('#product_category').val();
          var product_group    = $('#product_group').val();

          fetch_data(product_brand, product_category, product_group);
        });

        $("body").on("click", '.export-statement', function(event) {
          var product_brand    = $('#product_brand').val();
          var product_category = $('#product_category').val();
          var product_group    = $('#product_group').val();
          var queryStr         = "product_brand=" + product_brand + "&product_category=" + product_category + "&product_group=" + product_group;
          window.location.href="{!! route('products-price-list-export') !!}?"+queryStr; 
    });


      });
    </script>



    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

    <script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            $(this).hide();
            var printContents    = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });


</script>
    @endsection